/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformLMMEstimator
extends AbstractLMMEstimator<UniformDistribution> {
    public static final UniformLMMEstimator STATIC = new UniformLMMEstimator();

    private UniformLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public UniformDistribution estimateFromLMoments(double[] dArray) {
        return new UniformDistribution(Math.max(dArray[0] - 3.0 * dArray[1], -1.7976931348623157E308), Math.min(dArray[0] + 3.0 * dArray[1], Double.MAX_VALUE));
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

