/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public final class UniformKernelDensityFunction
implements KernelDensityFunction {
    public static final UniformKernelDensityFunction KERNEL = new UniformKernelDensityFunction();
    @Reference(authors="J.S. Marron, D. Nolan", title="Canonical kernels for density estimation", booktitle="Statistics & Probability Letters, Volume 7, Issue 3", url="http://dx.doi.org/10.1016/0167-7152(88)90050-8")
    public static final double CANONICAL_BANDWIDTH = Math.pow(4.5, 0.2);
    private static final double STDDEV = 1.0 / Math.sqrt(3.0);
    private static final double R = 0.5;

    private UniformKernelDensityFunction() {
    }

    @Override
    public double density(double d) {
        return d < 1.0 ? 0.5 : 0.0;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.5;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

