/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="T. W. Anderson, and D. A. Darling", title="Asymptotic theory of certain 'goodness of fit' criteria based on stochastic processes", booktitle="Annals of mathematical statistics 23(2)", url="http://dx.doi.org/10.1214/aoms/1177729437")
public class AndersonDarlingTest {
    public static final AndersonDarlingTest STATIC = new AndersonDarlingTest();

    public static double A2StandardNormal(double[] dArray) {
        double d;
        int n = dArray.length;
        assert (n > 0);
        double d2 = 0.0;
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 1;
        int n5 = (n3 << 1) + 1;
        while (n2 < n3) {
            d = NormalDistribution.standardNormalCDF(dArray[n2]);
            double d3 = NormalDistribution.standardNormalCDF(dArray[n3]);
            double d4 = Math.log(d) + Math.log(1.0 - d3);
            double d5 = Math.log(1.0 - d) + Math.log(d3);
            d2 += (double)n4 * d4 + (double)n5 * d5;
            ++n2;
            --n3;
            n4 += 2;
            n5 -= 2;
        }
        if (n2 == n3) {
            d = NormalDistribution.standardNormalCDF(dArray[n2]);
            d2 += (double)n4 * (Math.log(d) + Math.log(1.0 - d));
        }
        d2 /= (double)n;
        return -(d2 += (double)n);
    }

    public static double A2Noncentral(double[] dArray) {
        double d;
        int n = dArray.length;
        assert (n > 1);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i];
        }
        d2 /= (double)n;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = dArray[i] - d2;
            d3 += d4 * d4;
        }
        double d5 = (d3 /= (double)(n - 1)) > 0.0 ? Math.sqrt(1.0 / d3) : 1.0;
        double d6 = 0.0;
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 1;
        int n5 = (n3 << 1) + 1;
        while (n2 < n3) {
            d = NormalDistribution.standardNormalCDF((dArray[n2] - d2) * d5);
            double d7 = NormalDistribution.standardNormalCDF((dArray[n3] - d2) * d5);
            double d8 = Math.log(d) + Math.log(1.0 - d7);
            double d9 = Math.log(1.0 - d) + Math.log(d7);
            d6 += (double)n4 * d8 + (double)n5 * d9;
            ++n2;
            --n3;
            n4 += 2;
            n5 -= 2;
        }
        if (n2 == n3) {
            d = NormalDistribution.standardNormalCDF((dArray[n2] - d2) * d5);
            d6 += (double)n4 * (Math.log(d) + Math.log(1.0 - d));
        }
        d6 /= (double)n;
        return -(d6 += (double)n);
    }

    @Reference(authors="M. A. Stephens", title="EDF Statistics for Goodness of Fit and Some Comparisons", booktitle="Journal of the American Statistical Association, Volume 69, Issue 347", url="http://dx.doi.org/10.1080/01621459.1974.10480196")
    public static double removeBiasNormalDistribution(double d, int n) {
        return d * (1.0 + 4.0 / (double)n - 25.0 / (double)(n * n));
    }
}

