/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvaluationResult
extends BasicResult
implements TextWriteable,
Iterable<MeasurementGroup> {
    ArrayList<MeasurementGroup> groups = new ArrayList();
    ArrayList<String> header = new ArrayList();

    public EvaluationResult(String string, String string2) {
        super(string, string2);
    }

    public MeasurementGroup newGroup(String string) {
        MeasurementGroup measurementGroup = new MeasurementGroup(string);
        this.groups.add(measurementGroup);
        return measurementGroup;
    }

    public MeasurementGroup findOrCreateGroup(String string) {
        for (MeasurementGroup measurementGroup : this.groups) {
            if (!string.equals(measurementGroup.getName())) continue;
            return measurementGroup;
        }
        return this.newGroup(string);
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        for (MeasurementGroup measurementGroup : this.groups) {
            textWriterStream.commentPrintLn(measurementGroup.getName());
            textWriterStream.flush();
            for (Measurement measurement : measurementGroup) {
                textWriterStream.inlinePrintNoQuotes(measurement.name);
                textWriterStream.inlinePrintNoQuotes(measurement.val);
                textWriterStream.flush();
            }
        }
    }

    public void addHeader(String string) {
        this.header.add(string);
    }

    public Iterable<String> getHeaderLines() {
        return this.header;
    }

    @Override
    public Iterator<MeasurementGroup> iterator() {
        return this.groups.iterator();
    }

    public int numLines() {
        int n = this.header.size();
        for (MeasurementGroup measurementGroup : this.groups) {
            n += 1 + measurementGroup.measurements.size();
        }
        return n;
    }

    public static EvaluationResult findOrCreate(ResultHierarchy resultHierarchy, Result result, String string, String string2) {
        ArrayList<EvaluationResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, EvaluationResult.class);
        EvaluationResult evaluationResult = null;
        for (EvaluationResult evaluationResult2 : arrayList) {
            if (!string2.equals(evaluationResult2.getShortName())) continue;
            evaluationResult = evaluationResult2;
            break;
        }
        if (evaluationResult == null) {
            evaluationResult = new EvaluationResult(string, string2);
            resultHierarchy.add(result, evaluationResult);
        }
        return evaluationResult;
    }

    public boolean visualizeSingleton() {
        return false;
    }

    public static class Measurement {
        String name;
        double val;
        double min;
        double max;
        double exp;
        private boolean lowerisbetter;

        protected Measurement(String string, double d, double d2, double d3, boolean bl) {
            this(string, d, d2, d3, Double.NaN, bl);
        }

        protected Measurement(String string, double d, double d2, double d3, double d4, boolean bl) {
            this.name = string;
            this.val = d;
            this.min = d2;
            this.max = d3;
            this.exp = d4;
            this.lowerisbetter = bl;
        }

        public String getName() {
            return this.name;
        }

        public double getVal() {
            return this.val;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getExp() {
            return this.exp;
        }

        public boolean lowerIsBetter() {
            return this.lowerisbetter;
        }
    }

    public static class MeasurementGroup
    implements Iterable<Measurement> {
        private String groupname;
        private ArrayList<Measurement> measurements = new ArrayList();

        protected MeasurementGroup(String string) {
            this.groupname = string;
        }

        public String getName() {
            return this.groupname;
        }

        public MeasurementGroup addMeasure(String string, double d, double d2, double d3, boolean bl) {
            this.measurements.add(new Measurement(string, d, d2, d3, bl));
            return this;
        }

        public MeasurementGroup addMeasure(String string, double d, double d2, double d3, double d4, boolean bl) {
            this.measurements.add(new Measurement(string, d, d2, d3, d4, bl));
            return this;
        }

        @Override
        public Iterator<Measurement> iterator() {
            return this.measurements.iterator();
        }
    }
}

