/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import java.util.ArrayList;

public class ResultHierarchy
extends HashMapHierarchy<Result> {
    private static final Logging LOG = Logging.getLogger(ResultHierarchy.class);
    private ArrayList<ResultListener> listenerList = new ArrayList();

    @Override
    public boolean add(Result result, Result result2) {
        boolean bl = super.add(result, result2);
        if (bl && result2 instanceof HierarchicalResult) {
            HierarchicalResult hierarchicalResult = (HierarchicalResult)result2;
            ResultHierarchy resultHierarchy = hierarchicalResult.getHierarchy();
            hierarchicalResult.setHierarchy(this);
            Hierarchy.Iter<HierarchicalResult> iter = resultHierarchy.iterChildren(hierarchicalResult);
            while (iter.valid()) {
                Result result3 = iter.get();
                this.add(hierarchicalResult, result3);
                if (result3 instanceof HierarchicalResult) {
                    ((HierarchicalResult)result3).setHierarchy(this);
                }
                iter.advance();
            }
        }
        this.fireResultAdded(result2, result);
        return bl;
    }

    @Override
    public boolean remove(Result result, Result result2) {
        boolean bl = super.remove(result, result2);
        this.fireResultRemoved(result2, result);
        return bl;
    }

    public void addResultListener(ResultListener resultListener) {
        this.listenerList.add(resultListener);
    }

    public void removeResultListener(ResultListener resultListener) {
        this.listenerList.remove(resultListener);
    }

    public void resultChanged(Result result) {
        this.fireResultChanged(result);
    }

    private void fireResultAdded(Result result, Result result2) {
        if (LOG.isDebugging()) {
            LOG.debug("Result added: " + result + " <- " + result2);
        }
        int n = this.listenerList.size();
        while (--n >= 0) {
            this.listenerList.get(n).resultAdded(result, result2);
        }
    }

    private void fireResultChanged(Result result) {
        if (LOG.isDebugging()) {
            LOG.debug("Result changed: " + result);
        }
        int n = this.listenerList.size();
        while (--n >= 0) {
            this.listenerList.get(n).resultChanged(result);
        }
    }

    private void fireResultRemoved(Result result, Result result2) {
        if (LOG.isDebugging()) {
            LOG.debug("Result removed: " + result + " <- " + result2);
        }
        int n = this.listenerList.size();
        while (--n >= 0) {
            this.listenerList.get(n).resultRemoved(result, result2);
        }
    }
}

