/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ELKIServiceScanner {
    private static final Logging LOG = Logging.getLogger(ELKIServiceScanner.class);
    private static final URLClassLoader CLASSLOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
    public static final String FACTORY_POSTFIX = "$Factory";
    private static List<Class<?>> MASTER_CACHE = null;

    private ELKIServiceScanner() {
    }

    public static void load(Class<?> clazz) {
        if (MASTER_CACHE == null) {
            ELKIServiceScanner.initialize();
        }
        if (MASTER_CACHE.size() == 0) {
            return;
        }
        for (Class<?> clazz2 : MASTER_CACHE) {
            if (!clazz.isAssignableFrom(clazz2) || Modifier.isInterface(clazz2.getModifiers()) || Modifier.isAbstract(clazz2.getModifiers()) || Modifier.isPrivate(clazz2.getModifiers())) continue;
            boolean bl = false;
            try {
                bl = clazz2.getConstructor(new Class[0]) != null;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            try {
                bl = bl || ClassGenericsUtil.getParameterizer(clazz2) != null;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            if (!bl) continue;
            ELKIServiceRegistry.register(clazz, clazz2);
        }
    }

    public static Iterator<Class<?>> nonindexedClasses() {
        if (MASTER_CACHE == null) {
            ELKIServiceScanner.initialize();
        }
        if (MASTER_CACHE.size() == 0) {
            return Collections.emptyIterator();
        }
        return MASTER_CACHE.iterator();
    }

    private static synchronized void initialize() {
        Enumeration<URL> enumeration;
        if (MASTER_CACHE != null) {
            return;
        }
        try {
            enumeration = CLASSLOADER.getResources("");
        }
        catch (IOException iOException) {
            LoggingUtil.exception(iOException);
            return;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            File file;
            URL uRL = enumeration.nextElement();
            if (!"file".equals(uRL.getProtocol())) continue;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.warning("Incorrect classpath entry: " + uRL);
                continue;
            }
            DirClassIterator dirClassIterator = new DirClassIterator(file);
            while (dirClassIterator.hasNext()) {
                String string = (String)dirClassIterator.next();
                try {
                    Class<?> clazz = CLASSLOADER.loadClass(string);
                    if (clazz.getCanonicalName() == null) continue;
                    arrayList.add(clazz);
                }
                catch (Error | Exception throwable) {}
            }
        }
        MASTER_CACHE = Collections.unmodifiableList(arrayList);
        if (LOG.isDebuggingFinest() && MASTER_CACHE.size() > 0) {
            LOG.debugFinest("Classes found by scanning the development classpath: " + MASTER_CACHE.size());
        }
    }

    public static class ClassSorter
    implements Comparator<Class<?>> {
        @Override
        public int compare(Class<?> clazz, Class<?> clazz2) {
            Package package_ = clazz.getPackage();
            Package package_2 = clazz2.getPackage();
            if (package_ == null) {
                return -1;
            }
            if (package_2 == null) {
                return 1;
            }
            int n = package_.getName().compareTo(package_2.getName());
            if (n != 0) {
                return n;
            }
            return clazz.getCanonicalName().compareTo(clazz2.getCanonicalName());
        }
    }

    static class DirClassIterator
    implements Iterator<String> {
        private static final String CLASS_EXT = ".class";
        private static final String FACTORY_FILE_EXT = "$Factory.class";
        private static final int CLASS_EXT_LENGTH = ".class".length();
        private String prefix;
        private ArrayList<String> files = new ArrayList(100);
        private ArrayList<File> folders = new ArrayList(100);

        public DirClassIterator(File file) {
            this.prefix = file.getAbsolutePath();
            if (this.prefix.charAt(this.prefix.length() - 1) != File.separatorChar) {
                this.prefix = this.prefix + File.separatorChar;
            }
            this.folders.add(file);
        }

        @Override
        public boolean hasNext() {
            if (this.files.size() == 0) {
                this.findNext();
            }
            return this.files.size() > 0;
        }

        private void findNext() {
            while (this.folders.size() > 0) {
                File file = this.folders.remove(this.folders.size() - 1);
                if (!file.isDirectory()) continue;
                for (String string : file.list()) {
                    Object object;
                    if (string.charAt(0) == '.') continue;
                    if (string.endsWith(CLASS_EXT)) {
                        if (string.indexOf(36) >= 0 && !string.endsWith(FACTORY_FILE_EXT)) continue;
                        object = new File(file, string).toString();
                        this.files.add(((String)object).substring(this.prefix.length(), ((String)object).length() - CLASS_EXT_LENGTH).replace(File.separatorChar, '.'));
                        continue;
                    }
                    object = new File(file, string);
                    if (!((File)object).isDirectory()) continue;
                    this.folders.add((File)object);
                }
            }
        }

        @Override
        public String next() {
            if (this.files.size() == 0) {
                this.findNext();
            }
            if (this.files.size() > 0) {
                return this.files.remove(this.files.size() - 1);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

