/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.iterator;

import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayIter;
import java.util.List;

public class ArrayListIter<O>
implements ArrayIter {
    final List<O> data;
    int pos = 0;

    public ArrayListIter(List<O> list) {
        this.data = list;
    }

    @Override
    public boolean valid() {
        return this.pos < this.data.size() && this.pos >= 0;
    }

    @Override
    public ArrayIter advance() {
        ++this.pos;
        return this;
    }

    @Override
    public int getOffset() {
        return this.pos;
    }

    @Override
    public ArrayIter advance(int n) {
        this.pos += n;
        return this;
    }

    @Override
    public ArrayIter retract() {
        --this.pos;
        return this;
    }

    @Override
    public ArrayIter seek(int n) {
        this.pos = n;
        return this;
    }

    public O get() {
        return this.data.get(this.pos);
    }
}

