/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.DocumentationUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Collection;
import java.util.List;

public final class OptionUtil {
    private OptionUtil() {
    }

    public static <O extends Parameter<?>> String optionsNamesToString(List<O> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(((Parameter)list.get(i)).getName());
            if (i == list.size() - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static <O extends Parameter<?>> String optionsNamesToString(O[] OArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < OArray.length; ++i) {
            stringBuilder.append(OArray[i].getName());
            if (i == OArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static <N extends Parameter<?>> String parameterNamesAndValuesToString(List<N> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(((Parameter)list.get(i)).getName());
            stringBuilder.append(':');
            stringBuilder.append(((Parameter)list.get(i)).getValueAsString());
            if (i == list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static void formatForConsole(StringBuilder stringBuilder, int n, String string, Collection<TrackedParameter> collection) {
        for (TrackedParameter trackedParameter : collection) {
            String string2 = trackedParameter.getParameter().getName();
            String string3 = trackedParameter.getParameter().getSyntax();
            String string4 = trackedParameter.getParameter().getFullDescription();
            stringBuilder.append("-");
            stringBuilder.append(string2);
            stringBuilder.append(' ');
            stringBuilder.append(string3);
            stringBuilder.append(FormatUtil.NEWLINE);
            OptionUtil.println(stringBuilder, n, string4, string);
        }
    }

    public static void println(StringBuilder stringBuilder, int n, String string, String string2) {
        for (String string3 : FormatUtil.splitAtLastBlank(string, n - string2.length())) {
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            if (string3.endsWith(FormatUtil.NEWLINE)) continue;
            stringBuilder.append(FormatUtil.NEWLINE);
        }
    }

    public static StringBuilder describeParameterizable(StringBuilder stringBuilder, Class<?> clazz, int n, String string) {
        try {
            Reference reference;
            String string2;
            OptionUtil.println(stringBuilder, n, "Description for class " + clazz.getName(), "");
            String string3 = DocumentationUtil.getTitle(clazz);
            if (string3 != null && string3.length() > 0) {
                OptionUtil.println(stringBuilder, n, string3, "");
            }
            if ((string2 = DocumentationUtil.getDescription(clazz)) != null && string2.length() > 0) {
                OptionUtil.println(stringBuilder, n, string2, "  ");
            }
            if ((reference = DocumentationUtil.getReference(clazz)) != null) {
                if (reference.prefix().length() > 0) {
                    OptionUtil.println(stringBuilder, n, reference.prefix(), "");
                }
                OptionUtil.println(stringBuilder, n, reference.authors() + ":", "");
                OptionUtil.println(stringBuilder, n, reference.title(), "  ");
                OptionUtil.println(stringBuilder, n, "in: " + reference.booktitle(), "");
                if (reference.url().length() > 0) {
                    OptionUtil.println(stringBuilder, n, "see also: " + reference.url(), "");
                }
            }
            SerializedParameterization serializedParameterization = new SerializedParameterization();
            TrackParameters trackParameters = new TrackParameters(serializedParameterization);
            Object object = ClassGenericsUtil.tryInstantiate(Object.class, clazz, trackParameters);
            Collection<TrackedParameter> collection = trackParameters.getAllParameters();
            if (collection.size() > 0) {
                OptionUtil.formatForConsole(stringBuilder, n, string, collection);
            }
            return stringBuilder;
        }
        catch (Exception exception) {
            LoggingUtil.exception("Error instantiating class to describe.", exception.getCause());
            stringBuilder.append("No description available: ").append(exception);
            return stringBuilder;
        }
    }
}

