/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class NoDuplicateValueGlobalConstraint
implements GlobalParameterConstraint {
    private List<? extends AbstractParameter<?, ?>> parameters;

    public NoDuplicateValueGlobalConstraint(List<? extends AbstractParameter<?, ?>> list) {
        this.parameters = list;
    }

    public NoDuplicateValueGlobalConstraint(AbstractParameter<?, ?> ... abstractParameterArray) {
        this.parameters = Arrays.asList(abstractParameterArray);
    }

    @Override
    public void test() throws ParameterException {
        HashSet hashSet = new HashSet();
        for (Parameter parameter : this.parameters) {
            if (!parameter.isDefined() || hashSet.add(parameter.getValue())) continue;
            throw new WrongParameterValueException("Global Parameter Constraint Error:\nParameters " + OptionUtil.optionsNamesToString(this.parameters) + " must have different values. Current values: " + OptionUtil.parameterNamesAndValuesToString(this.parameters) + ".\n");
        }
    }

    @Override
    public String getDescription() {
        return "Parameters " + OptionUtil.optionsNamesToString(this.parameters) + " must have different values.";
    }
}

