/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;

public class RandomParameter
extends AbstractParameter<RandomParameter, RandomFactory> {
    Long seed = null;

    public RandomParameter(OptionID optionID) {
        super(optionID, RandomFactory.DEFAULT);
    }

    public RandomParameter(OptionID optionID, RandomFactory randomFactory) {
        super(optionID, randomFactory);
    }

    public RandomParameter(OptionID optionID, long l) {
        super(optionID, true);
        this.seed = l;
    }

    @Override
    public String getSyntax() {
        return "<long|Random>";
    }

    @Override
    public void setValue(Object object) throws ParameterException {
        if (object instanceof RandomFactory) {
            this.seed = null;
        } else if (object instanceof Long) {
            this.seed = (Long)object;
            object = RandomFactory.get(this.seed);
        } else if (object instanceof Number) {
            this.seed = ((Number)object).longValue();
            object = RandomFactory.get(this.seed);
        } else if ("global random".equals(object)) {
            object = RandomFactory.DEFAULT;
        } else {
            try {
                this.seed = Long.valueOf(object.toString());
                object = RandomFactory.get(this.seed);
            }
            catch (NullPointerException nullPointerException) {
                throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long seed value or a random generator factory, read: " + object + "!\n");
            }
            catch (NumberFormatException numberFormatException) {
                throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long seed value or a random generator factory, read: " + object + "!\n");
            }
        }
        super.setValue(object);
    }

    @Override
    protected RandomFactory parseValue(Object object) throws ParameterException {
        if (object instanceof RandomFactory) {
            return (RandomFactory)object;
        }
        if (object instanceof Long) {
            return RandomFactory.get((Long)object);
        }
        if (object instanceof Number) {
            return RandomFactory.get(((Number)object).longValue());
        }
        try {
            return RandomFactory.get(Long.valueOf(object.toString()));
        }
        catch (NullPointerException nullPointerException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long seed value or a random generator factory, read: " + object + "!\n");
        }
        catch (NumberFormatException numberFormatException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long seed value or a random generator factory, read: " + object + "!\n");
        }
    }

    @Override
    public Object getGivenValue() {
        Object object = super.getGivenValue();
        if (object != null && this.seed != null) {
            this.givenValue = RandomFactory.get(this.seed);
            object = this.givenValue;
        }
        return object;
    }

    @Override
    public String getValueAsString() {
        return this.seed != null ? this.seed.toString() : "null";
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == RandomFactory.DEFAULT) {
            return "global random";
        }
        return super.getDefaultValueAsString();
    }
}

