/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="J. Gao, P.-N. Tan", title="Converting Output Scores from Outlier Detection Algorithms into Probability Estimates", booktitle="Proc. Sixth International Conference on Data Mining, 2006. ICDM'06.", url="http://dx.doi.org/10.1109/ICDM.2006.43")
public class MixtureModelOutlierScalingFunction
implements OutlierScalingFunction {
    private static final Logging LOG = Logging.getLogger(MixtureModelOutlierScalingFunction.class);
    protected double mu;
    protected double sigma;
    protected double lambda;
    protected double alpha;
    public static final double ONEBYSQRT2PI = 1.0 / MathUtil.SQRTTWOPI;
    private static final double DELTA = 1.0E-4;

    protected static double calcP_i(double d, double d2, double d3) {
        double d4 = d - d2;
        return ONEBYSQRT2PI / d3 * Math.exp(d4 * d4 / (-2.0 * d3 * d3));
    }

    protected static double calcQ_i(double d, double d2) {
        return d2 * Math.exp(-d2 * d);
    }

    protected static double calcPosterior(double d, double d2, double d3, double d4, double d5) {
        double d6 = MixtureModelOutlierScalingFunction.calcP_i(d, d3, d4);
        double d7 = MixtureModelOutlierScalingFunction.calcQ_i(d, d5);
        return d2 * d6 / (d2 * d6 + (1.0 - d2) * d7);
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        double d;
        double d2;
        double d3;
        double d4;
        block7: {
            MeanVariance meanVariance = new MeanVariance();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d5 = doubleRelation.doubleValue(dBIDIter);
                if (!Double.isNaN(d5) && !Double.isInfinite(d5)) {
                    meanVariance.put(d5);
                }
                dBIDIter.advance();
            }
            d4 = meanVariance.getMean() * 2.0;
            if (d4 == 0.0) {
                d4 = Double.MIN_NORMAL;
            }
            d3 = Math.max(meanVariance.getSampleStddev(), Double.MIN_NORMAL);
            d2 = Math.min(1.0 / d4, Double.MAX_VALUE);
            d = 0.05;
            DBIDs dBIDs = doubleRelation.getDBIDs();
            int n = 0;
            do {
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                DBIDIter dBIDIter2 = dBIDs.iter();
                while (dBIDIter2.valid()) {
                    double d11 = doubleRelation.doubleValue(dBIDIter2);
                    double d12 = MixtureModelOutlierScalingFunction.calcPosterior(d11, d, d4, d3, d2);
                    d6 += d12;
                    d7 += 1.0 - d12;
                    d8 += d12 * d11;
                    d9 += (1.0 - d12) * d11;
                    d10 += d12 * d11 * d11;
                    dBIDIter2.advance();
                }
                if (d6 <= 0.0 || d8 <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block7;
                }
                double d13 = d8 / d6;
                double d14 = Math.max(Math.sqrt(d10 / d6 - d13 * d13), Double.MIN_NORMAL);
                double d15 = Math.min(d7 / d9, Double.MAX_VALUE);
                double d16 = d6 / (double)dBIDs.size();
                if (Math.abs(d13 - d4) < 1.0E-4 && Math.abs(d14 - d3) < 1.0E-4 && Math.abs(d15 - d2) < 1.0E-4 && Math.abs(d16 - d) < 1.0E-4) break block7;
                if (d14 <= 0.0 || d16 <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block7;
                }
                d4 = d13;
                d3 = d14;
                d2 = d15;
                d = d16;
            } while (++n <= 100);
            LOG.warning("Max iterations met in mixture model fitting.");
        }
        this.mu = d4;
        this.sigma = d3;
        this.lambda = d2;
        this.alpha = d;
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d;
        double d2;
        double d3;
        double d4;
        block6: {
            MeanVariance meanVariance = new MeanVariance();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d5 = numberArrayAdapter.getDouble(a, i);
                if (Double.isNaN(d5) || Double.isInfinite(d5)) continue;
                meanVariance.put(d5);
            }
            d4 = meanVariance.getMean() * 2.0;
            if (d4 == 0.0) {
                d4 = Double.MIN_NORMAL;
            }
            d3 = Math.max(meanVariance.getSampleStddev(), Double.MIN_NORMAL);
            d2 = Math.min(1.0 / d4, Double.MAX_VALUE);
            d = 0.05;
            int n2 = 0;
            do {
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d11 = numberArrayAdapter.getDouble(a, i);
                    double d12 = MixtureModelOutlierScalingFunction.calcPosterior(d11, d, d4, d3, d2);
                    d6 += d12;
                    d7 += 1.0 - d12;
                    d8 += d12 * d11;
                    d9 += (1.0 - d12) * d11;
                    d10 += d12 * d11 * d11;
                }
                if (d6 <= 0.0 || d8 <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block6;
                }
                double d13 = d8 / d6;
                double d14 = Math.max(Math.sqrt(d10 / d6 - d13 * d13), Double.MIN_NORMAL);
                double d15 = Math.min(d7 / d9, Double.MAX_VALUE);
                double d16 = d6 / (double)n;
                if (Math.abs(d13 - d4) < 1.0E-4 && Math.abs(d14 - d3) < 1.0E-4 && Math.abs(d15 - d2) < 1.0E-4 && Math.abs(d16 - d) < 1.0E-4) break block6;
                if (d14 <= 0.0 || d16 <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block6;
                }
                d4 = d13;
                d3 = d14;
                d2 = d15;
                d = d16;
            } while (++n2 <= 100);
            LOG.warning("Max iterations met in mixture model fitting.");
        }
        this.mu = d4;
        this.sigma = d3;
        this.lambda = d2;
        this.alpha = d;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double d) {
        double d2 = MixtureModelOutlierScalingFunction.calcPosterior(d, this.alpha, this.mu, this.sigma, this.lambda);
        if (Double.isNaN(d2)) {
            return 0.0;
        }
        return d2;
    }
}

