/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

public class OutlierSqrtScaling
implements OutlierScalingFunction {
    protected double min;
    protected double max;
    protected Double pmin = null;
    protected Double pmax = null;
    protected double factor;

    public OutlierSqrtScaling(Double d, Double d2) {
        this.pmin = d;
        this.pmax = d2;
    }

    @Override
    public double getScaled(double d) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (d <= this.min) {
            return 0.0;
        }
        return Math.min(1.0, Math.sqrt(d - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                if (!Double.isInfinite(d)) {
                    doubleMinMax.put(d);
                }
                dBIDIter.advance();
            }
            this.min = this.pmin == null ? doubleMinMax.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? doubleMinMax.getMax() : this.pmax.doubleValue();
        }
        this.factor = Math.sqrt(this.max - this.min);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                if (Double.isInfinite(d)) continue;
                doubleMinMax.put(d);
            }
            this.min = this.pmin == null ? doubleMinMax.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? doubleMinMax.getMax() : this.pmax.doubleValue();
        }
        this.factor = Math.sqrt(this.max - this.min);
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("sqrtscale.min", "Fixed minimum to use in sqrt scaling.");
        public static final OptionID MAX_ID = new OptionID("sqrtscale.max", "Fixed maximum to use in sqrt scaling.");
        protected double min;
        protected double max;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(MIN_ID);
            doubleParameter.setOptional(true);
            if (parameterization.grab(doubleParameter)) {
                this.min = (Double)doubleParameter.getValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(MAX_ID);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.max = (Double)doubleParameter2.getValue();
            }
        }

        @Override
        protected OutlierSqrtScaling makeInstance() {
            return new OutlierSqrtScaling(this.min, this.max);
        }
    }
}

