/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.MergedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationProcessor;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.style.PropertiesBasedStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class VisualizerParameterizer {
    private static final Logging LOG = Logging.getLogger(VisualizerParameterizer.class);
    public static final int DEFAULT_SAMPLE_SIZE = 10000;
    private StyleLibrary stylelib;
    private Collection<VisualizationProcessor> factories;
    private int samplesize = -1;
    private RandomFactory rnd = RandomFactory.DEFAULT;

    public VisualizerParameterizer(int n, StyleLibrary styleLibrary, Collection<VisualizationProcessor> collection) {
        this.samplesize = n;
        this.stylelib = styleLibrary;
        this.factories = collection;
    }

    public VisualizerContext newContext(ResultHierarchy resultHierarchy, Result result) {
        Relation relation = null;
        ArrayList<Relation> arrayList = ResultUtil.filterResults(resultHierarchy, Relation.class);
        for (Relation relation2 : arrayList) {
            if (!TypeUtil.DBID.isAssignableFrom(relation2.getDataTypeInformation()) && relation == null) {
                relation = relation2;
            }
            if (this.samplesize == 0 || !ResultUtil.filterResults(resultHierarchy, relation2, SamplingResult.class).isEmpty() || relation2.size() <= this.samplesize) continue;
            SamplingResult samplingResult = new SamplingResult(relation2);
            samplingResult.setSample(DBIDUtil.randomSample(samplingResult.getSample(), this.samplesize, this.rnd));
            ResultUtil.addChildResult(relation2, samplingResult);
        }
        return new VisualizerContext(resultHierarchy, result, relation, this.stylelib, this.factories);
    }

    /*
     * WARNING - void declaration
     */
    public static String getTitle(Database database, Result result) {
        void var4_6;
        ArrayList<TrackedParameter> arrayList = new ArrayList<TrackedParameter>();
        for (SettingsResult object2 : ResultUtil.getSettingsResults(result)) {
            arrayList.addAll(object2.getSettings());
        }
        Object object3 = null;
        Object var4_5 = null;
        String string = null;
        for (TrackedParameter trackedParameter : arrayList) {
            String string2;
            Parameter<?> parameter = trackedParameter.getParameter();
            OptionID optionID = parameter.getOptionID();
            String string3 = string2 = parameter.isDefined() ? parameter.getValueAsString() : null;
            if (optionID.equals(AlgorithmStep.Parameterizer.ALGORITHM_ID)) {
                object3 = string2;
            }
            if (optionID.equals(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID)) {
                String string4 = string2;
            }
            if (!optionID.equals(FileBasedDatabaseConnection.Parameterizer.INPUT_ID)) continue;
            string = string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object3 != null) {
            stringBuilder.append(VisualizerParameterizer.shortenClassname(((String)object3).split(",")[0], '.'));
        }
        if (var4_6 != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" using ");
            }
            stringBuilder.append(VisualizerParameterizer.shortenClassname((String)var4_6, '.'));
        }
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" on ");
            }
            stringBuilder.append(VisualizerParameterizer.shortenClassname(string, File.separatorChar));
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    protected static String shortenClassname(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLELIB_ID = new OptionID("visualizer.stylesheet", "Style properties file to use, included properties: classic, default, greyscale, neon, presentation, print");
        public static final OptionID ENABLEVIS_ID = new OptionID("vis.enable", "Visualizers to enable by default.");
        public static final OptionID SAMPLING_ID = new OptionID("vis.sampling", "Maximum number of objects to visualize by default (for performance reasons).");
        protected StyleLibrary stylelib = null;
        protected Pattern enableVisualizers = null;
        protected Collection<VisualizationProcessor> factories = null;
        protected int samplesize = -1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Object object;
            StringParameter stringParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(SAMPLING_ID, 10000).addConstraint(CommonConstraints.GREATER_EQUAL_MINUSONE_INT);
            if (parameterization.grab(intParameter)) {
                this.samplesize = intParameter.intValue();
            }
            if (parameterization.grab(stringParameter = new StringParameter(STYLELIB_ID, "default"))) {
                object = (String)stringParameter.getValue();
                try {
                    this.stylelib = new PropertiesBasedStyleLibrary((String)object, (String)object);
                }
                catch (AbortException abortException) {
                    parameterization.reportError(new WrongParameterValueException(stringParameter, (String)object, abortException));
                }
            }
            if (parameterization.grab((Parameter<?>)(object = (PatternParameter)new PatternParameter(ENABLEVIS_ID).setOptional(true))) && !"all".equals(((PatternParameter)object).getValueAsString())) {
                this.enableVisualizers = (Pattern)((AbstractParameter)object).getValue();
            }
            MergedParameterization mergedParameterization = new MergedParameterization(parameterization);
            this.factories = Parameterizer.collectFactorys(mergedParameterization, this.enableVisualizers);
        }

        private static <O> Collection<VisualizationProcessor> collectFactorys(MergedParameterization mergedParameterization, Pattern pattern) {
            ArrayList<VisualizationProcessor> arrayList = new ArrayList<VisualizationProcessor>();
            for (Class<?> clazz : ELKIServiceRegistry.findAllImplementations(VisualizationProcessor.class)) {
                if (pattern != null && !pattern.matcher(clazz.getCanonicalName()).find()) continue;
                try {
                    mergedParameterization.rewind();
                    VisualizationProcessor visualizationProcessor = ClassGenericsUtil.tryInstantiate(VisualizationProcessor.class, clazz, mergedParameterization);
                    arrayList.add(visualizationProcessor);
                }
                catch (Throwable throwable) {
                    if (LOG.isDebugging()) {
                        LOG.exception("Error instantiating visualization processor " + clazz.getName(), throwable.getCause());
                        continue;
                    }
                    LOG.warning("Error instantiating visualization processor " + clazz.getName() + ": " + throwable.getMessage());
                }
            }
            return arrayList;
        }

        @Override
        protected VisualizerParameterizer makeInstance() {
            return new VisualizerParameterizer(this.samplesize, this.stylelib, this.factories);
        }
    }
}

