/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public abstract class LazyCanvasResizer
extends ComponentAdapter {
    public static final double DEFAULT_THRESHOLD = 0.05;
    double threshold;
    double activeRatio;
    Component component;

    public LazyCanvasResizer(Component component, double d) {
        this.threshold = d;
        this.component = component;
        this.activeRatio = this.getCurrentRatio();
    }

    public LazyCanvasResizer(Component component) {
        this(component, 0.05);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        double d;
        if (componentEvent.getComponent() == this.component && Math.abs((d = this.getCurrentRatio()) - this.activeRatio) > this.threshold) {
            this.activeRatio = d;
            this.executeResize(d);
        }
    }

    public final double getCurrentRatio() {
        return (double)this.component.getWidth() / (double)this.component.getHeight();
    }

    public abstract void executeResize(double var1);

    public double getActiveRatio() {
        return this.activeRatio;
    }
}

