/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.savedialog;

import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaveOptionsPanel
extends JPanel {
    private static final String STR_IMAGE_SIZE = "Size options:";
    private static final String STR_JPEG_QUALITY = "Quality:";
    private static final String STR_IMAGE_HEIGHT = "Height:";
    private static final String STR_IMAGE_WIDTH = "Width:";
    private static final String STR_CHOOSE_FORMAT = "Choose format:";
    private static final String STR_RESET_IMAGE_SIZE = "Reset image size";
    private static final String STR_LOCK_ASPECT_RATIO = "Lock aspect ratio";
    private static final long serialVersionUID = 1L;
    private JFileChooser fc;
    protected int width = 1024;
    protected int height = 768;
    double ratio = 1.6;
    private JPanel mainPanel;
    private JPanel qualPanel;
    private JPanel sizePanel;
    protected JSpinner spinnerWidth;
    protected JSpinner spinnerHeight;
    protected JSpinner spinnerQual;
    protected SpinnerNumberModel modelWidth;
    protected SpinnerNumberModel modelHeight;
    protected SpinnerNumberModel modelQuality;
    protected JCheckBox aspectRatioLock;
    protected JButton resetSizeButton;
    protected JComboBox<String> formatSelector;
    private final boolean hasResetButton = false;

    public SaveOptionsPanel(JFileChooser jFileChooser, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.ratio = (double)n / (double)n2;
        this.fc = jFileChooser;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.sizePanel = new JPanel();
        this.sizePanel.setLayout(new BoxLayout(this.sizePanel, 1));
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(STR_IMAGE_SIZE));
        this.mainPanel.add(new JLabel(STR_CHOOSE_FORMAT));
        this.formatSelector = new JComboBox<String>(SVGSaveDialog.getVisibleFormats());
        this.formatSelector.setSelectedIndex(0);
        this.formatSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getItem() != null) {
                    String string = (String)SaveOptionsPanel.this.formatSelector.getSelectedItem();
                    SaveOptionsPanel.this.setFormat(string);
                }
            }
        });
        this.mainPanel.add(this.formatSelector);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.add(new JLabel(STR_IMAGE_WIDTH));
        jPanel2.add(new JLabel(STR_IMAGE_HEIGHT));
        this.modelWidth = new SpinnerNumberModel(this.width, 0, 100000, 1);
        this.modelHeight = new SpinnerNumberModel(this.height, 0, 100000, 1);
        this.spinnerWidth = new JSpinner(this.modelWidth);
        this.spinnerWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SaveOptionsPanel.this.aspectRatioLock.isSelected()) {
                    int n = SaveOptionsPanel.this.modelWidth.getNumber().intValue();
                    SaveOptionsPanel.this.spinnerHeight.setValue(new Integer((int)Math.round((double)n / SaveOptionsPanel.this.ratio)));
                }
            }
        });
        jPanel.add(this.spinnerWidth);
        this.spinnerHeight = new JSpinner(this.modelHeight);
        this.spinnerHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SaveOptionsPanel.this.aspectRatioLock.isSelected()) {
                    int n = SaveOptionsPanel.this.modelHeight.getNumber().intValue();
                    SaveOptionsPanel.this.spinnerWidth.setValue(new Integer((int)Math.round((double)n * SaveOptionsPanel.this.ratio)));
                }
            }
        });
        jPanel2.add(this.spinnerHeight);
        this.sizePanel.add(jPanel);
        this.sizePanel.add(jPanel2);
        this.aspectRatioLock = new JCheckBox(STR_LOCK_ASPECT_RATIO);
        this.aspectRatioLock.setSelected(true);
        this.sizePanel.add(this.aspectRatioLock);
        this.mainPanel.add(this.sizePanel);
        this.qualPanel = new JPanel();
        this.qualPanel.setVisible(false);
        this.qualPanel.setLayout(new BoxLayout(this.qualPanel, 1));
        this.qualPanel.setBorder(BorderFactory.createTitledBorder(STR_JPEG_QUALITY));
        this.modelQuality = new SpinnerNumberModel(0.7, 0.1, 1.0, 0.1);
        this.spinnerQual = new JSpinner(this.modelQuality);
        this.qualPanel.add(this.spinnerQual);
        this.mainPanel.add(this.qualPanel);
        this.add(this.mainPanel);
        this.fc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string;
                File file;
                if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty") && (file = (File)propertyChangeEvent.getNewValue()) != null && file.getName() != null && (string = SVGSaveDialog.guessFormat(file.getName())) != null) {
                    SaveOptionsPanel.this.setFormat(string);
                }
            }
        });
    }

    protected void setFormat(String string) {
        String[] stringArray = SVGSaveDialog.getVisibleFormats();
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n != this.formatSelector.getSelectedIndex() && n >= 0) {
            this.formatSelector.setSelectedIndex(n);
        }
        if (string.equals("jpeg") || string.equals("jpg")) {
            this.sizePanel.setVisible(true);
            this.qualPanel.setVisible(true);
        } else if (string.equals("png")) {
            this.sizePanel.setVisible(true);
            this.qualPanel.setVisible(false);
        } else if (string.equals("pdf")) {
            this.sizePanel.setVisible(false);
            this.qualPanel.setVisible(false);
            this.mainPanel.validate();
        } else if (string.equals("ps")) {
            this.sizePanel.setVisible(false);
            this.qualPanel.setVisible(false);
            this.mainPanel.validate();
        } else if (string.equals("eps")) {
            this.sizePanel.setVisible(false);
            this.qualPanel.setVisible(false);
            this.mainPanel.validate();
        } else if (string.equals("svg")) {
            this.sizePanel.setVisible(false);
            this.qualPanel.setVisible(false);
            this.mainPanel.validate();
        }
    }

    public String getSelectedFormat() {
        String string = (String)this.formatSelector.getSelectedItem();
        return string;
    }

    public double getJPEGQuality() {
        double d = this.modelQuality.getNumber().doubleValue();
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }
}

