/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class SVGSimpleLinearAxis {
    private static final String CSS_AXIS = "axis";
    private static final String CSS_AXIS_TICK = "axis-tick";
    private static final String CSS_AXIS_LABEL = "axis-label";

    private static void setupCSSClasses(Object object, CSSClassManager cSSClassManager, StyleLibrary styleLibrary) throws CSSClassManager.CSSNamingConflict {
        CSSClass cSSClass;
        if (!cSSClassManager.contains(CSS_AXIS)) {
            cSSClass = new CSSClass(object, CSS_AXIS);
            cSSClass.setStatement("stroke", styleLibrary.getColor(CSS_AXIS));
            cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth(CSS_AXIS));
            cSSClassManager.addClass(cSSClass);
        }
        if (!cSSClassManager.contains(CSS_AXIS_TICK)) {
            cSSClass = new CSSClass(object, CSS_AXIS_TICK);
            cSSClass.setStatement("stroke", styleLibrary.getColor("axis.tick"));
            cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("axis.tick"));
            cSSClassManager.addClass(cSSClass);
        }
        if (!cSSClassManager.contains(CSS_AXIS_LABEL)) {
            cSSClass = new CSSClass(object, CSS_AXIS_LABEL);
            cSSClass.setStatement("fill", styleLibrary.getTextColor("axis.label"));
            cSSClass.setStatement("font-family", styleLibrary.getFontFamily("axis.label"));
            cSSClass.setStatement("font-size", styleLibrary.getTextSize("axis.label"));
            cSSClassManager.addClass(cSSClass);
        }
    }

    public static void drawAxis(SVGPlot sVGPlot, Element element, LinearScale linearScale, double d, double d2, double d3, double d4, LabelStyle labelStyle, StyleLibrary styleLibrary) throws CSSClassManager.CSSNamingConflict {
        double d5;
        boolean bl;
        boolean bl2;
        assert (element != null);
        Element element2 = sVGPlot.svgLine(d, d2, d3, d4);
        SVGUtil.setCSSClass(element2, CSS_AXIS);
        element.appendChild(element2);
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = d7 * 0.01;
        double d9 = -d6 * 0.01;
        switch (labelStyle) {
            case LEFTHAND: 
            case RIGHTHAND: {
                bl2 = true;
                bl = true;
                break;
            }
            case NOLABELS: {
                bl2 = false;
                bl = true;
                break;
            }
            default: {
                bl2 = false;
                bl = false;
            }
        }
        Alignment alignment = Alignment.LL;
        if (bl2) {
            d5 = Math.atan2(d7, d6);
            alignment = d5 > 2.6 ? (labelStyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC) : (d5 > 0.5 ? (labelStyle == LabelStyle.RIGHTHAND ? Alignment.RR : Alignment.LL) : (d5 > -0.5 ? (labelStyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC) : (d5 > -2.6 ? (labelStyle == LabelStyle.RIGHTHAND ? Alignment.RL : Alignment.LR) : (labelStyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC))));
        }
        d5 = styleLibrary.getTextSize("axis.label") * 0.35;
        if (bl || bl2) {
            double d10;
            int n = 1;
            int n2 = (int)((linearScale.getMax() - linearScale.getMin()) / linearScale.getRes());
            double d11 = Math.sqrt(d6 * d6 + d7 * d7);
            if ((double)n * d11 / (double)n2 < (d10 = 10.0 * styleLibrary.getLineWidth("axis.tick"))) {
                for (int i = 2; i <= n2 >> 1; ++i) {
                    if (n2 % i != 0 || !((double)i * d11 / (double)n2 >= d10)) continue;
                    n = i;
                    break;
                }
            }
            if ((double)n * d11 / (double)n2 < d10) {
                n = (int)Math.floor(d10 * (double)n2 / d11);
            }
            for (double d12 = linearScale.getMin(); d12 <= linearScale.getMax() + linearScale.getRes() / 10.0; d12 += (double)n * linearScale.getRes()) {
                double d13 = d + d6 * linearScale.getScaled(d12);
                double d14 = d2 + d7 * linearScale.getScaled(d12);
                if (bl) {
                    Element element3 = sVGPlot.svgLine(d13 - d8, d14 - d9, d13 + d8, d14 + d9);
                    SVGUtil.setAtt(element3, "class", CSS_AXIS_TICK);
                    element.appendChild(element3);
                }
                if (!bl2) continue;
                double d15 = d13;
                double d16 = d14;
                switch (alignment) {
                    case LL: 
                    case LC: 
                    case LR: {
                        d15 = d13 + d8 * 2.5;
                        d16 = d14 + d9 * 2.5 + d5;
                        break;
                    }
                    case RL: 
                    case RC: 
                    case RR: {
                        d15 = d13 - d8 * 2.5;
                        d16 = d14 - d9 * 2.5 + d5;
                    }
                }
                Element element4 = sVGPlot.svgText(d15, d16, linearScale.formatValue(d12));
                element4.setAttribute("class", CSS_AXIS_LABEL);
                switch (alignment) {
                    case LL: 
                    case RL: {
                        element4.setAttribute("text-anchor", "start");
                        break;
                    }
                    case LC: 
                    case RC: {
                        element4.setAttribute("text-anchor", "middle");
                        break;
                    }
                    case LR: 
                    case RR: {
                        element4.setAttribute("text-anchor", "end");
                    }
                }
                element.appendChild(element4);
            }
        }
        if (labelStyle == LabelStyle.ENDLABEL) {
            Element element5 = sVGPlot.svgText(d - d6 * 0.02, d2 - d7 * 0.02 + d5, linearScale.formatValue(linearScale.getMin()));
            element5.setAttribute("class", CSS_AXIS_LABEL);
            element5.setAttribute("text-anchor", "middle");
            element.appendChild(element5);
            element5 = sVGPlot.svgText(d3 + d6 * 0.02, d4 + d7 * 0.02 + d5, linearScale.formatValue(linearScale.getMax()));
            element5.setAttribute("class", CSS_AXIS_LABEL);
            element5.setAttribute("text-anchor", "middle");
            element.appendChild(element5);
        }
        SVGSimpleLinearAxis.setupCSSClasses(sVGPlot, sVGPlot.getCSSClassManager(), styleLibrary);
    }

    public static enum LabelStyle {
        LEFTHAND,
        RIGHTHAND,
        NOLABELS,
        NOTHING,
        ENDLABEL;

    }

    private static enum Alignment {
        LL,
        RL,
        LC,
        RC,
        LR,
        RR;

    }
}

