/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class PolygonVisualization
extends AbstractVisFactory {
    private static final String NAME = "Polygons";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewResultVis(visualizerContext, object, Relation.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<Relation<?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, Relation<?> relation, ScatterPlotProjector<?> scatterPlotProjector) {
                if (!TypeUtil.POLYGON_TYPE.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                if (RelationUtil.dimensionality(scatterPlotProjector.getRelation()) != 2) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(PolygonVisualization.NAME, visualizerContext, relation, relation, PolygonVisualization.this);
                visualizationTask.level = 90;
                visualizationTask.addUpdateFlags(1);
                visualizerContext.addVis(relation, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String POLYS = "polys";
        protected final Relation<PolygonsObject> rep;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.rep = (Relation)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            CSSClass cSSClass = new CSSClass(this.svgp, POLYS);
            cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot.polygons"));
            cSSClass.setStatement("stroke", styleLibrary.getColor("plot.polygons"));
            cSSClass.setStatement("fill", "none");
            this.svgp.addCSSClassOrLogError(cSSClass);
            this.svgp.updateStyleElement();
            DBIDIter dBIDIter = this.rep.iterDBIDs();
            while (dBIDIter.valid()) {
                try {
                    PolygonsObject polygonsObject = this.rep.get(dBIDIter);
                    if (polygonsObject != null) {
                        SVGPath sVGPath = new SVGPath();
                        for (Polygon polygon : polygonsObject.getPolygons()) {
                            Vector vector = polygon.get(0);
                            double[] dArray = this.proj.fastProjectDataToRenderSpace(vector.getArrayRef());
                            sVGPath.moveTo(dArray[0], dArray[1]);
                            ArrayListIter<Vector> arrayListIter = polygon.iter();
                            while (arrayListIter.valid()) {
                                if (arrayListIter.getOffset() != 0) {
                                    double[] dArray2 = this.proj.fastProjectDataToRenderSpace(arrayListIter.get().getArrayRef());
                                    sVGPath.drawTo(dArray2[0], dArray2[1]);
                                }
                                arrayListIter.advance();
                            }
                            sVGPath.drawTo(dArray[0], dArray[1]);
                        }
                        Element element = sVGPath.makeElement(this.svgp);
                        SVGUtil.addCSSClass(element, POLYS);
                        this.layer.appendChild(element);
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                dBIDIter.advance();
            }
        }
    }
}

