/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geometry.GrahamScanConvexHull2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.EmptyParameterization;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class EMClusterVisualization
extends AbstractVisFactory {
    private static final String NAME = "EM Cluster Models";
    static final double[] sigma = new double[]{0.41, 0.223, 0.047};

    @Override
    public Instance makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, scatterPlotProjector.getRelation(), this);
            visualizationTask.level = 103;
            visualizationTask.addUpdateFlags(4);
            visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String EMBORDER = "EMClusterBorder";
        private static final double KAPPA = 0.5522847498;
        private int times;
        private int opacStyle;
        private int softBorder;
        private int drawStyle;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.times = 3;
            this.opacStyle = 1;
            this.softBorder = 1;
            this.drawStyle = 0;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            List<Cluster<?>> list = clustering.getAllClusters();
            if (list.size() <= 1) {
                return;
            }
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            PCARunner pCARunner = (PCARunner)ClassGenericsUtil.parameterizeOrAbort(PCARunner.class, new EmptyParameterization());
            Iterator<Cluster<?>> iterator = list.iterator();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                Cluster<?> cluster = iterator.next();
                DBIDs dBIDs = cluster.getIDs();
                if (dBIDs.size() <= 0 || !(cluster.getModel() instanceof EMModel)) continue;
                EMModel eMModel = (EMModel)cluster.getModel();
                String string = "EMClusterBorder_" + i;
                if (!this.svgp.getCSSClassManager().contains(string)) {
                    object2 = new CSSClass(this, string);
                    ((CSSClass)object2).setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.5);
                    object = colorLibrary.getColor(i);
                    if (this.softBorder == 0) {
                        ((CSSClass)object2).setStatement("stroke", (String)object);
                    }
                    ((CSSClass)object2).setStatement("fill", (String)object);
                    ((CSSClass)object2).setStatement("fill-opacity", 0.15);
                    this.svgp.addCSSClassOrLogError((CSSClass)object2);
                }
                object2 = eMModel.getCovarianceMatrix();
                object = eMModel.getMean();
                Vector vector = new Vector(this.proj.fastProjectDataToRenderSpace((NumberVector)object));
                SortedEigenPairs sortedEigenPairs = pCARunner.processCovarMatrix((Matrix)object2).getEigenPairs();
                Vector[] vectorArray = new Vector[sortedEigenPairs.size()];
                for (int j = 0; j < sortedEigenPairs.size(); ++j) {
                    EigenPair eigenPair = sortedEigenPairs.getEigenPair(j);
                    Vector vector2 = eigenPair.getEigenvector().times(Math.sqrt(eigenPair.getEigenvalue()));
                    vectorArray[j] = new Vector(this.proj.fastProjectRelativeDataToRenderSpace(vector2.getArrayRef()));
                }
                if (this.drawStyle != 0 || sortedEigenPairs.size() == 2) {
                    this.drawSphere2D(string, vector, vectorArray);
                    continue;
                }
                Polygon polygon = this.makeHullComplex(vectorArray);
                this.drawHullLines(string, vector, polygon);
            }
        }

        protected void drawSphere2D(String string, Vector vector, Vector[] vectorArray) {
            CSSClass cSSClass = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            for (int i = 0; i < vectorArray.length - 1; ++i) {
                for (int j = i + 1; j < vectorArray.length; ++j) {
                    for (int k = 1; k <= this.times; ++k) {
                        SVGPath sVGPath = new SVGPath();
                        Vector vector2 = vector.plusTimes(vectorArray[i], k);
                        Vector vector3 = vector.plusTimes(vectorArray[j], k);
                        Vector vector4 = vector.minusTimes(vectorArray[i], k);
                        Vector vector5 = vector.minusTimes(vectorArray[j], k);
                        sVGPath.moveTo(vector2);
                        sVGPath.cubicTo(vector2.plusTimes(vectorArray[j], 0.5522847498 * (double)k), vector3.plusTimes(vectorArray[i], 0.5522847498 * (double)k), vector3);
                        sVGPath.cubicTo(vector3.minusTimes(vectorArray[i], 0.5522847498 * (double)k), vector4.plusTimes(vectorArray[j], 0.5522847498 * (double)k), vector4);
                        sVGPath.cubicTo(vector4.minusTimes(vectorArray[j], 0.5522847498 * (double)k), vector5.minusTimes(vectorArray[i], 0.5522847498 * (double)k), vector5);
                        sVGPath.cubicTo(vector5.plusTimes(vectorArray[i], 0.5522847498 * (double)k), vector2.minusTimes(vectorArray[j], 0.5522847498 * (double)k), vector2);
                        sVGPath.close();
                        Element element = sVGPath.makeElement(this.svgp);
                        SVGUtil.addCSSClass(element, string);
                        if (cSSClass != null) {
                            double d = k >= 1 && k <= sigma.length ? sigma[k - 1] : 0.0;
                            cSSClass.setStatement("fill-opacity", d);
                            SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
                        }
                        this.layer.appendChild(element);
                    }
                }
            }
        }

        protected void drawHullLines(String string, Vector vector, Polygon polygon) {
            if (polygon.size() <= 1) {
                return;
            }
            CSSClass cSSClass = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            for (int i = 1; i <= this.times; ++i) {
                SVGPath sVGPath = new SVGPath();
                for (int j = 0; j < polygon.size(); ++j) {
                    sVGPath.drawTo(vector.plusTimes(polygon.get(j), i));
                }
                sVGPath.close();
                Element element = sVGPath.makeElement(this.svgp);
                SVGUtil.addCSSClass(element, string);
                if (cSSClass != null) {
                    double d = i >= 1 && i <= sigma.length ? sigma[i - 1] : 0.0;
                    cSSClass.setStatement("fill-opacity", d);
                    SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
                }
                this.layer.appendChild(element);
            }
        }

        protected Polygon makeHull(Vector[] vectorArray) {
            GrahamScanConvexHull2D grahamScanConvexHull2D = new GrahamScanConvexHull2D();
            Vector vector = new Vector(0.0, 0.0);
            for (int i = 0; i < vectorArray.length; ++i) {
                grahamScanConvexHull2D.add(vectorArray[i]);
                grahamScanConvexHull2D.add(vectorArray[i].times(-1.0));
                for (int j = i + 1; j < vectorArray.length; ++j) {
                    Vector vector2 = vectorArray[j];
                    Vector vector3 = vectorArray[i].plus(vector2).timesEquals(MathUtil.SQRTHALF);
                    Vector vector4 = vectorArray[i].minus(vector2).timesEquals(MathUtil.SQRTHALF);
                    grahamScanConvexHull2D.add(vector3);
                    grahamScanConvexHull2D.add(vector3.times(-1.0));
                    grahamScanConvexHull2D.add(vector4);
                    grahamScanConvexHull2D.add(vector4.times(-1.0));
                }
                vector.plusEquals(vectorArray[i]);
            }
            vector.timesEquals(1.0 / Math.sqrt(vectorArray.length));
            grahamScanConvexHull2D.add(vector);
            grahamScanConvexHull2D.add(vector.times(-1.0));
            return grahamScanConvexHull2D.getHull();
        }

        protected Polygon makeHullComplex(Vector[] vectorArray) {
            GrahamScanConvexHull2D grahamScanConvexHull2D = new GrahamScanConvexHull2D();
            Vector vector = new Vector(0.0, 0.0);
            for (int i = 0; i < vectorArray.length; ++i) {
                grahamScanConvexHull2D.add(vectorArray[i]);
                grahamScanConvexHull2D.add(vectorArray[i].times(-1.0));
                for (int j = i + 1; j < vectorArray.length; ++j) {
                    Vector vector2 = vectorArray[j];
                    Vector vector3 = vectorArray[i].plus(vector2).timesEquals(MathUtil.SQRTHALF);
                    Vector vector4 = vectorArray[i].minus(vector2).timesEquals(MathUtil.SQRTHALF);
                    grahamScanConvexHull2D.add(vector3);
                    grahamScanConvexHull2D.add(vector3.times(-1.0));
                    grahamScanConvexHull2D.add(vector4);
                    grahamScanConvexHull2D.add(vector4.times(-1.0));
                    for (int k = j + 1; k < vectorArray.length; ++k) {
                        Vector vector5 = vectorArray[j];
                        Vector vector6 = vector3.plus(vector5).timesEquals(Math.sqrt(0.3333333333333333));
                        Vector vector7 = vector4.plus(vector5).timesEquals(Math.sqrt(0.3333333333333333));
                        Vector vector8 = vector3.minus(vector5).timesEquals(Math.sqrt(0.3333333333333333));
                        Vector vector9 = vector4.minus(vector5).timesEquals(Math.sqrt(0.3333333333333333));
                        grahamScanConvexHull2D.add(vector6);
                        grahamScanConvexHull2D.add(vector6.times(-1.0));
                        grahamScanConvexHull2D.add(vector7);
                        grahamScanConvexHull2D.add(vector7.times(-1.0));
                        grahamScanConvexHull2D.add(vector8);
                        grahamScanConvexHull2D.add(vector8.times(-1.0));
                        grahamScanConvexHull2D.add(vector9);
                        grahamScanConvexHull2D.add(vector9.times(-1.0));
                    }
                }
                vector.plusEquals(vectorArray[i]);
            }
            vector.timesEquals(1.0 / Math.sqrt(vectorArray.length));
            grahamScanConvexHull2D.add(vector);
            grahamScanConvexHull2D.add(vector.times(-1.0));
            return grahamScanConvexHull2D.getHull();
        }

        protected void drawHullArc(String string, Vector vector, Polygon polygon) {
            if (polygon.size() <= 1) {
                return;
            }
            CSSClass cSSClass = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            for (int i = 1; i <= this.times; ++i) {
                Vector vector2;
                Vector vector3;
                Vector vector4;
                Vector vector5;
                int n;
                SVGPath sVGPath = new SVGPath();
                ArrayList<Vector> arrayList = new ArrayList<Vector>(polygon.size());
                for (n = 0; n < polygon.size(); ++n) {
                    vector5 = polygon.get((n - 1 + polygon.size()) % polygon.size());
                    vector4 = polygon.get(n);
                    vector3 = polygon.get((n + 1) % polygon.size());
                    vector2 = vector3.minus(vector4).normalize();
                    Vector vector6 = vector4.minus(vector5).normalize();
                    arrayList.add(vector2.plus(vector6));
                }
                for (n = 0; n < polygon.size(); ++n) {
                    vector5 = vector.plus(polygon.get(n));
                    vector4 = vector.plus(polygon.get((n + 1) % polygon.size()));
                    vector3 = (Vector)arrayList.get(n);
                    vector2 = (Vector)arrayList.get((n + 1) % polygon.size());
                    this.drawArc(sVGPath, vector, vector5, vector4, vector3, vector2, i);
                }
                sVGPath.close();
                Element element = sVGPath.makeElement(this.svgp);
                SVGUtil.addCSSClass(element, string);
                if (cSSClass != null) {
                    double d = i >= 1 && i <= sigma.length ? sigma[i - 1] : 0.0;
                    cSSClass.setStatement("fill-opacity", d);
                    SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
                }
                this.layer.appendChild(element);
            }
        }

        private void drawArc(SVGPath sVGPath, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, double d) {
            Vector vector6 = vector2.minus(vector);
            Vector vector7 = vector3.minus(vector);
            Vector vector8 = vector2.minus(vector3);
            Vector vector9 = vector.plusTimes(vector6, d);
            Vector vector10 = vector.plusTimes(vector7, d);
            double d2 = vector8.get(0) * vector5.get(1) - vector8.get(1) * vector5.get(0);
            double d3 = vector8.get(0) * vector4.get(1) - vector8.get(1) * vector4.get(0);
            double d4 = vector4.get(1) * vector5.get(0) - vector4.get(0) * vector5.get(1);
            if (d4 == 0.0) {
                LoggingUtil.warning("Parallel?!?");
                sVGPath.drawTo(vector10.get(0), vector10.get(1));
                return;
            }
            double d5 = Math.abs(d2 / d4);
            double d6 = Math.abs(d3 / d4);
            Vector vector11 = vector9.plusTimes(vector4, 0.5522847498 * d * d5);
            Vector vector12 = vector10.minusTimes(vector5, 0.5522847498 * d * d6);
            if (!sVGPath.isStarted()) {
                sVGPath.moveTo(vector9);
            }
            sVGPath.cubicTo(vector11, vector12, vector10);
        }
    }
}

