/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGScoreBar;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class EvaluationVisualization
extends AbstractVisFactory {
    private static final String NAME = "Evaluation Bar Chart";
    private static final double BARLENGTH = 5.0;
    private static final double BARHEIGHT = 0.7;

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<EvaluationResult> iter = VisualizationTree.filterResults(visualizerContext, object, EvaluationResult.class);
        while (iter.valid()) {
            block7: {
                Object object2;
                EvaluationResult evaluationResult = iter.get();
                Hierarchy.Iter<VisualizationTask> iter2 = VisualizationTree.filter(visualizerContext, evaluationResult, VisualizationTask.class);
                while (iter2.valid()) {
                    if (!(iter2.get().getFactory() instanceof EvaluationVisualization)) {
                        iter2.advance();
                        continue;
                    }
                    break block7;
                }
                if (evaluationResult.visualizeSingleton()) {
                    Object object3;
                    object2 = evaluationResult.getClass();
                    Hierarchy.Iter<Result> iter3 = visualizerContext.getVisHierarchy().iterChildren(visualizerContext.getBaseResult());
                    while (iter3.valid()) {
                        VisualizationTask visualizationTask;
                        object3 = iter3.get();
                        if (!(object3 instanceof VisualizationTask) || !((visualizationTask = (VisualizationTask)object3).getFactory() instanceof EvaluationVisualization) || visualizationTask.getResult() != object2) {
                            iter3.advance();
                            continue;
                        }
                        break block7;
                    }
                    object3 = new VisualizationTask(NAME, visualizerContext, object2, null, this);
                    ((VisualizationTask)object3).reqwidth = 0.5;
                    ((VisualizationTask)object3).reqheight = (double)evaluationResult.numLines() * 0.05;
                    ((VisualizationTask)object3).level = 200;
                    ((VisualizationTask)object3).addUpdateFlags(4);
                    visualizerContext.addVis(visualizerContext.getBaseResult(), (VisualizationItem)object3);
                } else {
                    object2 = new VisualizationTask(NAME, visualizerContext, evaluationResult, null, this);
                    ((VisualizationTask)object2).reqwidth = 0.5;
                    ((VisualizationTask)object2).reqheight = (double)evaluationResult.numLines() * 0.05;
                    ((VisualizationTask)object2).level = 200;
                    visualizerContext.addVis(evaluationResult, (VisualizationItem)object2);
                }
            }
            iter.advance();
        }
    }

    private double addBarChart(SVGPlot sVGPlot, Element element, double d, String string, double d2, double d3, double d4, double d5, boolean bl) {
        SVGScoreBar sVGScoreBar = new SVGScoreBar();
        sVGScoreBar.setFill(d2, d5 == d5 ? d5 : d3, d4);
        sVGScoreBar.setReversed(bl);
        sVGScoreBar.showValues(FormatUtil.NF4);
        sVGScoreBar.addLabel(string);
        element.appendChild(sVGScoreBar.build(sVGPlot, 0.0, d, 5.0, 0.7));
        return d += 1.0;
    }

    private double addHeader(SVGPlot sVGPlot, Element element, double d, String string) {
        Element element2 = sVGPlot.svgText(0.0, (d += 0.5) + 0.35, string);
        element2.setAttribute("style", "font-size: 0.6; font-weight: bold");
        element.appendChild(element2);
        return d += 1.0;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        Object object;
        Iterator<EvaluationResult.Measurement> iterator;
        Iterator<EvaluationResult.MeasurementGroup> iterator2;
        StylingPolicy object32;
        double d3 = -0.5;
        Element element = visualizationPlot.svgElement("g");
        Object r = visualizationTask.getResult();
        EvaluationResult evaluationResult = null;
        if (r instanceof EvaluationResult) {
            evaluationResult = (EvaluationResult)r;
        } else if (r instanceof Class && (object32 = ((VisualizerContext)((Object)(iterator2 = visualizationTask.getContext()))).getStylingPolicy()) instanceof ClusterStylingPolicy) {
            iterator = (ClusterStylingPolicy)object32;
            Object object2 = (Class)r;
            Hierarchy.Iter iter = VisualizationTree.filterResults(iterator2, ((ClusterStylingPolicy)((Object)iterator)).getClustering(), object2);
            while (iter.valid()) {
                block10: {
                    object = ((VisualizerContext)((Object)iterator2)).getHierarchy().iterAncestors((EvaluationResult)iter.get());
                    while (object.valid()) {
                        if (!(object.get() instanceof Clustering) || object.get() == ((ClusterStylingPolicy)((Object)iterator)).getClustering()) {
                            object.advance();
                            continue;
                        }
                        break block10;
                    }
                    evaluationResult = (EvaluationResult)iter.get();
                    break;
                }
                iter.advance();
            }
        }
        if (evaluationResult == null) {
            return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element);
        }
        for (String string : evaluationResult.getHeaderLines()) {
            d3 = this.addHeader(visualizationPlot, element, d3, string);
        }
        for (EvaluationResult.MeasurementGroup measurementGroup : evaluationResult) {
            d3 = this.addHeader(visualizationPlot, element, d3, measurementGroup.getName());
            for (Object object2 : measurementGroup) {
                d3 = this.addBarChart(visualizationPlot, element, d3, ((EvaluationResult.Measurement)object2).getName(), ((EvaluationResult.Measurement)object2).getVal(), ((EvaluationResult.Measurement)object2).getMin(), ((EvaluationResult.Measurement)object2).getMax(), ((EvaluationResult.Measurement)object2).getExp(), ((EvaluationResult.Measurement)object2).lowerIsBetter());
            }
        }
        double d4 = 10.0;
        iterator = visualizationTask.getContext().getStyleLibrary();
        double d5 = iterator.getSize("margin");
        object = SVGUtil.makeMarginTransform(d, d2, d4, d3, d5 / 100.0);
        SVGUtil.setAtt(element, "transform", (String)object);
        return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }
}

