/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.AutomaticEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.ArrayList;
import java.util.List;

public class EvaluationStep
implements WorkflowStep {
    private List<Evaluator> evaluators = null;
    private Result stepresult;

    public EvaluationStep(List<Evaluator> list) {
        this.evaluators = list;
    }

    public void runEvaluators(ResultHierarchy resultHierarchy, Database database) {
        this.stepresult = new BasicResult("Evaluation Step", "evaluation-step");
        if (this.evaluators != null) {
            new Evaluation(resultHierarchy, this.evaluators).update(database);
        }
    }

    public Result getResult() {
        return this.stepresult;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private List<Evaluator> evaluators = null;
        public static final OptionID EVALUATOR_ID = new OptionID("evaluator", "Class to evaluate the results with.");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ArrayList<Class<AutomaticEvaluation>> arrayList = new ArrayList<Class<AutomaticEvaluation>>(1);
            arrayList.add(AutomaticEvaluation.class);
            ObjectListParameter objectListParameter = new ObjectListParameter(EVALUATOR_ID, Evaluator.class);
            objectListParameter.setDefaultValue(arrayList);
            if (parameterization.grab(objectListParameter)) {
                this.evaluators = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected EvaluationStep makeInstance() {
            return new EvaluationStep(this.evaluators);
        }
    }

    public class Evaluation
    implements ResultListener {
        private List<Evaluator> evaluators;
        private ResultHierarchy hier;

        public Evaluation(ResultHierarchy resultHierarchy, List<Evaluator> list) {
            this.hier = resultHierarchy;
            this.evaluators = list;
            resultHierarchy.addResultListener(this);
        }

        public void update(Result result) {
            for (Evaluator evaluator : this.evaluators) {
                Thread.currentThread().setName(evaluator.toString());
                evaluator.processNewResult(this.hier, result);
            }
        }

        @Override
        public void resultAdded(Result result, Result result2) {
            this.update(result);
        }

        @Override
        public void resultChanged(Result result) {
        }

        @Override
        public void resultRemoved(Result result, Result result2) {
        }
    }
}

