/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SimpleRandomMutation
implements MutationOperator<DoubleSolution> {
    private double mutationProbability;
    private JMetalRandom randomGenerator;

    public SimpleRandomMutation(double probability) {
        if (probability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + this.mutationProbability);
        }
        this.mutationProbability = probability;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    private void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (!(this.randomGenerator.nextDouble() <= probability)) continue;
            Double value = solution.getLowerBound(i) + (solution.getUpperBound(i) - solution.getLowerBound(i)) * this.randomGenerator.nextDouble();
            solution.setVariableValue(i, value);
        }
    }
}

