/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.MiningFieldMetaInfo;

public class NormContinuous
extends Expression {
    private static final long serialVersionUID = 4714332374909851542L;
    protected String m_fieldName;
    protected int m_fieldIndex;
    protected boolean m_mapMissingDefined = false;
    protected double m_mapMissingTo;
    protected MiningFieldMetaInfo.Outlier m_outlierTreatmentMethod = MiningFieldMetaInfo.Outlier.ASIS;
    protected double[] m_linearNormOrig;
    protected double[] m_linearNormNorm;

    public NormContinuous(Element normCont, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        NodeList lnL;
        String outliers;
        if (opType != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[NormContinuous] can only have a continuous optype");
        }
        this.m_fieldName = normCont.getAttribute("field");
        String mapMissing = normCont.getAttribute("mapMissingTo");
        if (mapMissing != null && mapMissing.length() > 0) {
            this.m_mapMissingTo = Double.parseDouble(mapMissing);
            this.m_mapMissingDefined = true;
        }
        if ((outliers = normCont.getAttribute("outliers")) != null && outliers.length() > 0) {
            MiningFieldMetaInfo.Outlier[] outlierArray = MiningFieldMetaInfo.Outlier.values();
            int n = outlierArray.length;
            int n2 = 0;
            while (n2 < n) {
                MiningFieldMetaInfo.Outlier o = outlierArray[n2];
                if (o.toString().equals(outliers)) {
                    this.m_outlierTreatmentMethod = o;
                    break;
                }
                ++n2;
            }
        }
        if ((lnL = normCont.getElementsByTagName("LinearNorm")).getLength() < 2) {
            throw new Exception("[NormContinuous] Must be at least 2 LinearNorm elements!");
        }
        this.m_linearNormOrig = new double[lnL.getLength()];
        this.m_linearNormNorm = new double[lnL.getLength()];
        int i = 0;
        while (i < lnL.getLength()) {
            Node lnN = lnL.item(i);
            if (lnN.getNodeType() == 1) {
                Element lnE = (Element)lnN;
                String orig = lnE.getAttribute("orig");
                this.m_linearNormOrig[i] = Double.parseDouble(orig);
                String norm = lnE.getAttribute("norm");
                this.m_linearNormNorm[i] = Double.parseDouble(norm);
            }
            ++i;
        }
        if (fieldDefs != null) {
            this.setUpField();
        }
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[NormContinuous] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            Attribute field = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!field.isNumeric()) {
                throw new Exception("[NormContinuous] reference field " + this.m_fieldName + " must be continuous.");
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        return new Attribute(String.valueOf(this.m_fieldName) + "_normContinuous");
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double[] a = this.m_linearNormOrig;
        double[] b = this.m_linearNormNorm;
        return this.computeNorm(a, b, incoming);
    }

    public double getResultInverse(double[] incoming) {
        double[] a = this.m_linearNormNorm;
        double[] b = this.m_linearNormOrig;
        return this.computeNorm(a, b, incoming);
    }

    private double computeNorm(double[] a, double[] b, double[] incoming) {
        double result = 0.0;
        if (Utils.isMissingValue(incoming[this.m_fieldIndex])) {
            result = this.m_mapMissingDefined ? this.m_mapMissingTo : incoming[this.m_fieldIndex];
        } else {
            double x = incoming[this.m_fieldIndex];
            if (x < a[0]) {
                if (this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASIS) {
                    double slope = (b[1] - b[0]) / (a[1] - a[0]);
                    double offset = b[0] - slope * a[0];
                    result = slope * x + offset;
                } else {
                    result = this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASEXTREMEVALUES ? b[0] : this.m_mapMissingTo;
                }
            } else if (x > a[a.length - 1]) {
                int length = a.length;
                if (this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASIS) {
                    double slope = (b[length - 1] - b[length - 2]) / (a[length - 1] - a[length - 2]);
                    double offset = b[length - 1] - slope * a[length - 1];
                    result = slope * x + offset;
                } else {
                    result = this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASEXTREMEVALUES ? b[length - 1] : this.m_mapMissingTo;
                }
            } else {
                int i = 1;
                while (i < a.length) {
                    if (x <= a[i]) {
                        result = b[i - 1];
                        result += (x - a[i - 1]) / (a[i] - a[i - 1]) * (b[i] - b[i - 1]);
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        throw new Exception("[NormContinuous] Can't return the result as a categorical value!");
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(pad) + "NormContinuous (" + this.m_fieldName + "):\n" + pad + "linearNorm: ");
        int i = 0;
        while (i < this.m_linearNormOrig.length) {
            buff.append(this.m_linearNormOrig[i] + ":" + this.m_linearNormNorm[i] + " ");
            ++i;
        }
        buff.append("\n" + pad);
        buff.append("outlier treatment: " + this.m_outlierTreatmentMethod.toString());
        if (this.m_mapMissingDefined) {
            buff.append("\n" + pad);
            buff.append("map missing values to: " + this.m_mapMissingTo);
        }
        return buff.toString();
    }
}

