/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class RenameNominalValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private static final long serialVersionUID = -2121767582746512209L;
    protected String m_selectedColsString = "";
    protected Range m_selectedCols = new Range();
    protected String m_renameVals = "";
    protected boolean m_ignoreCase = false;
    protected boolean m_invert = false;
    protected int[] m_selectedAttributes;
    protected Map<String, String> m_renameMap = new HashMap<String, String>();

    public String globalInfo() {
        return "Renames the values of nominal attributes.";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        block19: {
            super.setInputFormat(instanceInfo);
            classIndex = instanceInfo.classIndex();
            if (this.m_renameVals != null && this.m_renameVals.length() > 0) {
                var7_4 = vals = this.m_renameVals.split(",");
                var6_8 = vals.length;
                var5_11 = 0;
                while (var5_11 < var6_8) {
                    val = var7_4[var5_11];
                    parts = val.split(":");
                    if (parts.length != 2) {
                        throw new WekaException("Invalid replacement string: " + val);
                    }
                    if (parts[0].length() == 0 || parts[1].length() == 0) {
                        throw new WekaException("Invalid replacement string: " + val);
                    }
                    this.m_renameMap.put(this.m_ignoreCase != false ? parts[0].toLowerCase().trim() : parts[0].trim(), parts[1].trim());
                    ++var5_11;
                }
            }
            tempRange = new Range();
            tempRange.setInvert(this.m_invert);
            if (this.m_selectedColsString == null) {
                this.m_selectedColsString = "";
            }
            try {
                tempRange.setRanges(this.m_selectedColsString);
                tempRange.setUpper(instanceInfo.numAttributes() - 1);
                this.m_selectedAttributes = tempRange.getSelection();
                this.m_selectedCols = tempRange;
                break block19;
            }
            catch (Exception r) {
                indexes = new StringBuffer();
                attNames = this.m_selectedColsString.split(",");
                first = true;
                var11_18 = attNames;
                var10_19 = attNames.length;
                var9_20 = 0;
                ** while (var9_20 < var10_19)
            }
lbl-1000:
            // 1 sources

            {
                n = var11_18[var9_20];
                found = instanceInfo.attribute(n = n.trim());
                if (found == null) {
                    throw new WekaException("Unable to find attribute '" + n + "' in the incoming instances'");
                }
                if (first) {
                    indexes.append("" + (found.index() + 1));
                    first = false;
                } else {
                    indexes.append("," + (found.index() + 1));
                }
                ++var9_20;
                continue;
            }
lbl50:
            // 1 sources

            tempRange = new Range();
            tempRange.setRanges(indexes.toString());
            tempRange.setUpper(instanceInfo.numAttributes() - 1);
            this.m_selectedAttributes = tempRange.getSelection();
            this.m_selectedCols = tempRange;
        }
        attributes = new ArrayList<Attribute>();
        i = 0;
        while (i < instanceInfo.numAttributes()) {
            if (this.m_selectedCols.isInRange(i)) {
                if (instanceInfo.attribute(i).isNominal()) {
                    valsForAtt = new ArrayList<String>();
                    j = 0;
                    while (j < instanceInfo.attribute(i).numValues()) {
                        origV = instanceInfo.attribute(i).value(j);
                        v0 = replace = this.m_ignoreCase != false ? this.m_renameMap.get(origV.toLowerCase()) : this.m_renameMap.get(origV);
                        if (replace != null && !valsForAtt.contains(replace)) {
                            valsForAtt.add(replace);
                        } else {
                            valsForAtt.add(origV);
                        }
                        ++j;
                    }
                    newAtt = new Attribute(instanceInfo.attribute(i).name(), valsForAtt);
                    attributes.add(newAtt);
                } else {
                    att = (Attribute)instanceInfo.attribute(i).copy();
                    attributes.add(att);
                }
            } else {
                att = (Attribute)instanceInfo.attribute(i).copy();
                attributes.add(att);
            }
            ++i;
        }
        outputFormat = new Instances(instanceInfo.relationName(), attributes, 0);
        outputFormat.setClassIndex(classIndex);
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.getOutputFormat().numAttributes() == 0) {
            return false;
        }
        if (this.m_selectedAttributes.length == 0) {
            this.push(instance);
        } else {
            double[] vals = new double[this.getOutputFormat().numAttributes()];
            int i = 0;
            while (i < instance.numAttributes()) {
                double currentV = instance.value(i);
                if (!this.m_selectedCols.isInRange(i)) {
                    vals[i] = currentV;
                } else if (currentV == Utils.missingValue()) {
                    vals[i] = currentV;
                } else {
                    String currentS = instance.attribute(i).value((int)currentV);
                    String replace = this.m_ignoreCase ? this.m_renameMap.get(currentS.toLowerCase()) : this.m_renameMap.get(currentS);
                    vals[i] = replace == null ? currentV : (double)this.getOutputFormat().attribute(i).indexOfValue(replace);
                }
                ++i;
            }
            AbstractInstance inst = null;
            inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
            inst.setDataset(this.getOutputFormat());
            this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
            inst.setDataset(this.getOutputFormat());
            this.push(inst);
        }
        return true;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public String selectedAttributesTipText() {
        return "The attributes (index range string or explicit comma-separated attribute names) to work on";
    }

    public void setSelectedAttributes(String atts) {
        this.m_selectedColsString = atts;
    }

    public String getSelectedAttributes() {
        return this.m_selectedColsString;
    }

    public String valueReplacementsTipText() {
        return "A comma separated list of values to replace and their replacements. E.g. red:green, blue:purple, fred:bob";
    }

    public void setValueReplacements(String v) {
        this.m_renameVals = v;
    }

    public String getValueReplacements() {
        return this.m_renameVals;
    }

    public String invertSelectionTipText() {
        return "Determines whether to apply the operation to the specified. attributes, or all attributes but the specified ones. If set to true, all attributes but the speficied ones will be affected.";
    }

    public boolean getInvertSelection() {
        return this.m_invert;
    }

    public void setInvertSelection(boolean invert) {
        this.m_invert = invert;
    }

    public String ignoreCaseTipText() {
        return "Whether to ignore case when matching nominal values";
    }

    public void setIgnoreCase(boolean ignore) {
        this.m_ignoreCase = ignore;
    }

    public boolean getIgnoreCase() {
        return this.m_ignoreCase;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tAttributes to act on. Can be either a range\n\tstring (e.g. 1,2,6-10) OR a comma-separated list of named attributes\n\t(default none)", "R", 1, "-R"));
        newVector.addElement(new Option("\tInvert matching sense (i.e. act on all attributes other than those specified)", "V", 0, "-V"));
        newVector.addElement(new Option("\tNominal labels and their replacement values.\n\tE.g. red:blue, black:white, fred:bob", "N", 1, "-N"));
        newVector.addElement(new Option("\tIgnore case when matching nominal values", "I", 0, "-I"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String replacements;
        String atts = Utils.getOption('R', options);
        if (atts.length() > 0) {
            this.setSelectedAttributes(atts);
        }
        if ((replacements = Utils.getOption('N', options)).length() > 0) {
            this.setValueReplacements(replacements);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        this.setIgnoreCase(Utils.getFlag('I', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> opts = new ArrayList<String>();
        if (this.getSelectedAttributes() != null && this.getSelectedAttributes().length() > 0) {
            opts.add("-R");
            opts.add(this.getSelectedAttributes());
        }
        if (this.getInvertSelection()) {
            opts.add("-V");
        }
        if (this.getValueReplacements() != null && this.getValueReplacements().length() > 0) {
            opts.add("-N");
            opts.add(this.getValueReplacements());
        }
        if (this.getIgnoreCase()) {
            opts.add("-I");
        }
        return opts.toArray(new String[opts.size()]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        RenameNominalValues.runFilter(new RenameNominalValues(), argv);
    }
}

