/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.IterativeClassifier;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.classifiers.trees.adtree.TwoWayNominalSplit;
import weka.classifiers.trees.adtree.TwoWayNumericSplit;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ADTree
extends RandomizableClassifier
implements OptionHandler,
Drawable,
AdditionalMeasureProducer,
WeightedInstancesHandler,
IterativeClassifier,
TechnicalInformationHandler {
    static final long serialVersionUID = -1532264837167690683L;
    public static final int SEARCHPATH_ALL = 0;
    public static final int SEARCHPATH_HEAVIEST = 1;
    public static final int SEARCHPATH_ZPURE = 2;
    public static final int SEARCHPATH_RANDOM = 3;
    public static final Tag[] TAGS_SEARCHPATH = new Tag[]{new Tag(0, "Expand all paths"), new Tag(1, "Expand the heaviest path"), new Tag(2, "Expand the best z-pure path"), new Tag(3, "Expand a random path")};
    protected Instances m_trainInstances;
    protected PredictionNode m_root = null;
    protected Random m_random = null;
    protected int m_lastAddedSplitNum = 0;
    protected int[] m_numericAttIndices;
    protected int[] m_nominalAttIndices;
    protected double m_trainTotalWeight;
    protected ReferenceInstances m_posTrainInstances;
    protected ReferenceInstances m_negTrainInstances;
    protected PredictionNode m_search_bestInsertionNode;
    protected Splitter m_search_bestSplitter;
    protected double m_search_smallestZ;
    protected Instances m_search_bestPathPosInstances;
    protected Instances m_search_bestPathNegInstances;
    protected int m_nodesExpanded = 0;
    protected int m_examplesCounted = 0;
    protected int m_boostingIterations = 10;
    protected int m_searchPath = 0;
    protected int m_randomSeed = 0;
    protected boolean m_saveInstanceData = false;

    public String globalInfo() {
        return "Class for generating an alternating decision tree. The basic algorithm is based on:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "This version currently only supports two-class problems. The number of boosting " + "iterations needs to be manually tuned to suit the dataset and the desired " + "complexity/accuracy tradeoff. Induction of the trees has been optimized, and heuristic " + "search methods have been introduced to speed learning.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Freund, Y. and Mason, L.");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.TITLE, "The alternating decision tree learning algorithm");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceeding of the Sixteenth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Bled, Slovenia");
        result.setValue(TechnicalInformation.Field.PAGES, "124-133");
        return result;
    }

    public void initializeClassifier(Instances instances) throws Exception {
        this.m_nodesExpanded = 0;
        this.m_examplesCounted = 0;
        this.m_lastAddedSplitNum = 0;
        this.m_random = instances.getRandomNumberGenerator((long)this.m_Seed);
        this.m_trainInstances = new Instances(instances);
        this.m_posTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_trainInstances.numInstances());
        this.m_negTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_trainInstances.numInstances());
        for (Instance instance : this.m_trainInstances) {
            Instance inst = instance;
            if ((int)inst.classValue() == 0) {
                this.m_negTrainInstances.addReference(inst);
                continue;
            }
            this.m_posTrainInstances.addReference(inst);
        }
        this.m_posTrainInstances.compactify();
        this.m_negTrainInstances.compactify();
        double rootPredictionValue = this.calcPredictionValue(this.m_posTrainInstances, this.m_negTrainInstances);
        this.m_root = new PredictionNode(rootPredictionValue);
        this.updateWeights(this.m_posTrainInstances, this.m_negTrainInstances, rootPredictionValue);
        this.generateAttributeIndicesSingle();
    }

    public boolean next() throws Exception {
        this.boost();
        return true;
    }

    public void boost() throws Exception {
        if (this.m_trainInstances == null || this.m_trainInstances.numInstances() == 0) {
            throw new Exception("Trying to boost with no training data");
        }
        this.searchForBestTestSingle();
        if (this.m_search_bestSplitter == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            ReferenceInstances posInstances = this.m_search_bestSplitter.instancesDownBranch(i, this.m_search_bestPathPosInstances);
            ReferenceInstances negInstances = this.m_search_bestSplitter.instancesDownBranch(i, this.m_search_bestPathNegInstances);
            double predictionValue = this.calcPredictionValue(posInstances, negInstances);
            PredictionNode newPredictor = new PredictionNode(predictionValue);
            this.updateWeights(posInstances, negInstances, predictionValue);
            this.m_search_bestSplitter.setChildForBranch(i, newPredictor);
        }
        this.m_search_bestInsertionNode.addChild(this.m_search_bestSplitter, this);
        this.m_search_bestPathPosInstances = null;
        this.m_search_bestPathNegInstances = null;
        this.m_search_bestSplitter = null;
    }

    private void generateAttributeIndicesSingle() {
        int i;
        ArrayList<Integer> nominalIndices = new ArrayList<Integer>();
        ArrayList<Integer> numericIndices = new ArrayList<Integer>();
        for (i = 0; i < this.m_trainInstances.numAttributes(); ++i) {
            if (i == this.m_trainInstances.classIndex()) continue;
            if (this.m_trainInstances.attribute(i).isNumeric()) {
                numericIndices.add(new Integer(i));
                continue;
            }
            nominalIndices.add(new Integer(i));
        }
        this.m_nominalAttIndices = new int[nominalIndices.size()];
        for (i = 0; i < nominalIndices.size(); ++i) {
            this.m_nominalAttIndices[i] = (Integer)nominalIndices.get(i);
        }
        this.m_numericAttIndices = new int[numericIndices.size()];
        for (i = 0; i < numericIndices.size(); ++i) {
            this.m_numericAttIndices[i] = (Integer)numericIndices.get(i);
        }
    }

    private void searchForBestTestSingle() throws Exception {
        this.m_trainTotalWeight = this.m_trainInstances.sumOfWeights();
        this.m_search_smallestZ = Double.POSITIVE_INFINITY;
        this.searchForBestTestSingle(this.m_root, this.m_posTrainInstances, this.m_negTrainInstances);
    }

    private void searchForBestTestSingle(PredictionNode currentNode, Instances posInstances, Instances negInstances) throws Exception {
        if (posInstances.numInstances() == 0 || negInstances.numInstances() == 0) {
            return;
        }
        if (this.calcZpure(posInstances, negInstances) >= this.m_search_smallestZ) {
            return;
        }
        ++this.m_nodesExpanded;
        this.m_examplesCounted += posInstances.numInstances() + negInstances.numInstances();
        for (int m_nominalAttIndice : this.m_nominalAttIndices) {
            this.evaluateNominalSplitSingle(m_nominalAttIndice, currentNode, posInstances, negInstances);
        }
        if (this.m_numericAttIndices.length > 0) {
            Instances allInstances = new Instances(posInstances);
            for (Instance instance : negInstances) {
                allInstances.add(instance);
            }
            for (int m_numericAttIndice : this.m_numericAttIndices) {
                this.evaluateNumericSplitSingle(m_numericAttIndice, currentNode, posInstances, negInstances, allInstances);
            }
        }
        if (currentNode.getChildren().size() == 0) {
            return;
        }
        switch (this.m_searchPath) {
            case 0: {
                this.goDownAllPathsSingle(currentNode, posInstances, negInstances);
                break;
            }
            case 1: {
                this.goDownHeaviestPathSingle(currentNode, posInstances, negInstances);
                break;
            }
            case 2: {
                this.goDownZpurePathSingle(currentNode, posInstances, negInstances);
                break;
            }
            case 3: {
                this.goDownRandomPathSingle(currentNode, posInstances, negInstances);
            }
        }
    }

    private void goDownAllPathsSingle(PredictionNode currentNode, Instances posInstances, Instances negInstances) throws Exception {
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            for (int i = 0; i < split.getNumOfBranches(); ++i) {
                this.searchForBestTestSingle(split.getChildForBranch(i), split.instancesDownBranch(i, posInstances), split.instancesDownBranch(i, negInstances));
            }
        }
    }

    private void goDownHeaviestPathSingle(PredictionNode currentNode, Instances posInstances, Instances negInstances) throws Exception {
        Splitter heaviestSplit = null;
        int heaviestBranch = 0;
        double largestWeight = 0.0;
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            for (int i = 0; i < split.getNumOfBranches(); ++i) {
                double weight = split.instancesDownBranch(i, posInstances).sumOfWeights() + split.instancesDownBranch(i, negInstances).sumOfWeights();
                if (!(weight > largestWeight)) continue;
                heaviestSplit = split;
                heaviestBranch = i;
                largestWeight = weight;
            }
        }
        if (heaviestSplit != null) {
            this.searchForBestTestSingle(heaviestSplit.getChildForBranch(heaviestBranch), heaviestSplit.instancesDownBranch(heaviestBranch, posInstances), heaviestSplit.instancesDownBranch(heaviestBranch, negInstances));
        }
    }

    private void goDownZpurePathSingle(PredictionNode currentNode, Instances posInstances, Instances negInstances) throws Exception {
        double lowestZpure = this.m_search_smallestZ;
        PredictionNode bestPath = null;
        ReferenceInstances bestPosSplit = null;
        ReferenceInstances bestNegSplit = null;
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            for (int i = 0; i < split.getNumOfBranches(); ++i) {
                ReferenceInstances negSplit;
                ReferenceInstances posSplit = split.instancesDownBranch(i, posInstances);
                double newZpure = this.calcZpure(posSplit, negSplit = split.instancesDownBranch(i, negInstances));
                if (!(newZpure < lowestZpure)) continue;
                lowestZpure = newZpure;
                bestPath = split.getChildForBranch(i);
                bestPosSplit = posSplit;
                bestNegSplit = negSplit;
            }
        }
        if (bestPath != null) {
            this.searchForBestTestSingle(bestPath, bestPosSplit, bestNegSplit);
        }
    }

    private void goDownRandomPathSingle(PredictionNode currentNode, Instances posInstances, Instances negInstances) throws Exception {
        ArrayList<Splitter> children = currentNode.getChildren();
        Splitter split = children.get(this.getRandom(children.size()));
        int branch = this.getRandom(split.getNumOfBranches());
        this.searchForBestTestSingle(split.getChildForBranch(branch), split.instancesDownBranch(branch, posInstances), split.instancesDownBranch(branch, negInstances));
    }

    private void evaluateNominalSplitSingle(int attIndex, PredictionNode currentNode, Instances posInstances, Instances negInstances) {
        double[] indexAndZ = this.findLowestZNominalSplit(posInstances, negInstances, attIndex);
        if (indexAndZ[1] < this.m_search_smallestZ) {
            this.m_search_smallestZ = indexAndZ[1];
            this.m_search_bestInsertionNode = currentNode;
            this.m_search_bestSplitter = new TwoWayNominalSplit(attIndex, (int)indexAndZ[0]);
            this.m_search_bestPathPosInstances = posInstances;
            this.m_search_bestPathNegInstances = negInstances;
        }
    }

    private void evaluateNumericSplitSingle(int attIndex, PredictionNode currentNode, Instances posInstances, Instances negInstances, Instances allInstances) throws Exception {
        double[] splitAndZ = this.findLowestZNumericSplit(allInstances, attIndex);
        if (splitAndZ[1] < this.m_search_smallestZ) {
            this.m_search_smallestZ = splitAndZ[1];
            this.m_search_bestInsertionNode = currentNode;
            this.m_search_bestSplitter = new TwoWayNumericSplit(attIndex, splitAndZ[0]);
            this.m_search_bestPathPosInstances = posInstances;
            this.m_search_bestPathNegInstances = negInstances;
        }
    }

    private double calcPredictionValue(Instances posInstances, Instances negInstances) {
        return 0.5 * Math.log((posInstances.sumOfWeights() + 1.0) / (negInstances.sumOfWeights() + 1.0));
    }

    private double calcZpure(Instances posInstances, Instances negInstances) {
        double posWeight = posInstances.sumOfWeights();
        double negWeight = negInstances.sumOfWeights();
        return 2.0 * (Math.sqrt(posWeight + 1.0) + Math.sqrt(negWeight + 1.0)) + (this.m_trainTotalWeight - (posWeight + negWeight));
    }

    private void updateWeights(Instances posInstances, Instances negInstances, double predictionValue) {
        Instance inst;
        Instance instance;
        double weightMultiplier = Math.pow(Math.E, -predictionValue);
        Iterator i$ = posInstances.iterator();
        while (i$.hasNext()) {
            inst = instance = (Instance)i$.next();
            inst.setWeight(inst.weight() * weightMultiplier);
        }
        weightMultiplier = Math.pow(Math.E, predictionValue);
        i$ = negInstances.iterator();
        while (i$.hasNext()) {
            inst = instance = (Instance)i$.next();
            inst.setWeight(inst.weight() * weightMultiplier);
        }
    }

    private double[] findLowestZNominalSplit(Instances posInstances, Instances negInstances, int attIndex) {
        double lowestZ = Double.MAX_VALUE;
        int bestIndex = 0;
        double[] posWeights = this.attributeValueWeights(posInstances, attIndex);
        double[] negWeights = this.attributeValueWeights(negInstances, attIndex);
        double posWeight = Utils.sum((double[])posWeights);
        double negWeight = Utils.sum((double[])negWeights);
        int maxIndex = posWeights.length;
        if (maxIndex == 2) {
            maxIndex = 1;
        }
        for (int i = 0; i < maxIndex; ++i) {
            double w1 = posWeights[i] + 1.0;
            double w2 = negWeights[i] + 1.0;
            double w3 = posWeight - w1 + 2.0;
            double w4 = negWeight - w2 + 2.0;
            double wRemainder = this.m_trainTotalWeight + 4.0 - (w1 + w2 + w3 + w4);
            double newZ = 2.0 * (Math.sqrt(w1 * w2) + Math.sqrt(w3 * w4)) + wRemainder;
            if (!(newZ < lowestZ)) continue;
            lowestZ = newZ;
            bestIndex = i;
        }
        double[] indexAndZ = new double[]{bestIndex, lowestZ};
        return indexAndZ;
    }

    private double[] attributeValueWeights(Instances instances, int attIndex) {
        double[] weights = new double[instances.attribute(attIndex).numValues()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = 0.0;
        }
        for (Instance instance : instances) {
            Instance inst = instance;
            if (inst.isMissing(attIndex)) continue;
            int n = (int)inst.value(attIndex);
            weights[n] = weights[n] + inst.weight();
        }
        return weights;
    }

    private double[] findLowestZNumericSplit(Instances instances, int attIndex) throws Exception {
        Instance inst;
        int i;
        double splitPoint = 0.0;
        double bestVal = Double.MAX_VALUE;
        int numMissing = 0;
        double[][] distribution = new double[3][instances.numClasses()];
        for (i = 0; i < instances.numInstances(); ++i) {
            inst = instances.instance(i);
            if (!inst.isMissing(attIndex)) {
                double[] dArray = distribution[1];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] + inst.weight();
                continue;
            }
            double[] dArray = distribution[2];
            int n = (int)inst.classValue();
            dArray[n] = dArray[n] + inst.weight();
            ++numMissing;
        }
        instances.sort(attIndex);
        for (i = 0; i < instances.numInstances() - (numMissing + 1); ++i) {
            inst = instances.instance(i);
            Instance instPlusOne = instances.instance(i + 1);
            double[] dArray = distribution[0];
            int n = (int)inst.classValue();
            dArray[n] = dArray[n] + inst.weight();
            double[] dArray2 = distribution[1];
            int n2 = (int)inst.classValue();
            dArray2[n2] = dArray2[n2] - inst.weight();
            if (!Utils.sm((double)inst.value(attIndex), (double)instPlusOne.value(attIndex))) continue;
            double currCutPoint = (inst.value(attIndex) + instPlusOne.value(attIndex)) / 2.0;
            double currVal = this.conditionedZOnRows(distribution);
            if (!(currVal < bestVal)) continue;
            splitPoint = currCutPoint;
            bestVal = currVal;
        }
        double[] splitAndZ = new double[]{splitPoint, bestVal};
        return splitAndZ;
    }

    private double conditionedZOnRows(double[][] distribution) {
        double w1 = distribution[0][0] + 1.0;
        double w2 = distribution[0][1] + 1.0;
        double w3 = distribution[1][0] + 1.0;
        double w4 = distribution[1][1] + 1.0;
        double wRemainder = this.m_trainTotalWeight + 4.0 - (w1 + w2 + w3 + w4);
        return 2.0 * (Math.sqrt(w1 * w2) + Math.sqrt(w3 * w4)) + wRemainder;
    }

    public double[] distributionForInstance(Instance instance) {
        double predVal = this.predictionValueForInstance(instance, this.m_root, 0.0);
        double[] distribution = new double[]{1.0 / (1.0 + Math.pow(Math.E, predVal)), 1.0 / (1.0 + Math.pow(Math.E, -predVal))};
        return distribution;
    }

    protected double predictionValueForInstance(Instance inst, PredictionNode currentNode, double currentValue) {
        currentValue += currentNode.getValue();
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            int branch = split.branchInstanceGoesDown(inst);
            if (branch < 0) continue;
            currentValue = this.predictionValueForInstance(inst, split.getChildForBranch(branch), currentValue);
        }
        return currentValue;
    }

    public String toString() {
        if (this.m_root == null) {
            return "ADTree not built yet";
        }
        return "Alternating decision tree:\n\n" + this.toString(this.m_root, 1) + "\nLegend: " + this.legend() + "\nTree size (total number of nodes): " + this.numOfAllNodes(this.m_root) + "\nLeaves (number of predictor nodes): " + this.numOfPredictionNodes(this.m_root);
    }

    protected String toString(PredictionNode currentNode, int level) {
        StringBuffer text = new StringBuffer();
        text.append(": " + Utils.doubleToString((double)currentNode.getValue(), (int)3));
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            for (int j = 0; j < split.getNumOfBranches(); ++j) {
                PredictionNode child = split.getChildForBranch(j);
                if (child == null) continue;
                text.append("\n");
                for (int k = 0; k < level; ++k) {
                    text.append("|  ");
                }
                text.append("(" + split.orderAdded + ")");
                text.append(split.attributeString(this.m_trainInstances) + " " + split.comparisonString(j, this.m_trainInstances));
                text.append(this.toString(child, level + 1));
            }
        }
        return text.toString();
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("digraph ADTree {\n");
        this.graphTraverse(this.m_root, text, 0, 0, this.m_trainInstances);
        return text.toString() + "}\n";
    }

    protected void graphTraverse(PredictionNode currentNode, StringBuffer text, int splitOrder, int predOrder, Instances instances) throws Exception {
        text.append("S" + splitOrder + "P" + predOrder + " [label=\"");
        text.append(Utils.doubleToString((double)currentNode.getValue(), (int)3));
        if (splitOrder == 0) {
            text.append(" (" + this.legend() + ")");
        }
        text.append("\" shape=box style=filled");
        if (instances.numInstances() > 0) {
            text.append(" data=\n" + instances + "\n,\n");
        }
        text.append("]\n");
        Enumeration<Splitter> e = currentNode.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            text.append("S" + splitOrder + "P" + predOrder + "->" + "S" + split.orderAdded + " [style=dotted]\n");
            text.append("S" + split.orderAdded + " [label=\"" + split.orderAdded + ": " + Utils.backQuoteChars((String)split.attributeString(this.m_trainInstances)) + "\"]\n");
            for (int i = 0; i < split.getNumOfBranches(); ++i) {
                PredictionNode child = split.getChildForBranch(i);
                if (child == null) continue;
                text.append("S" + split.orderAdded + "->" + "S" + split.orderAdded + "P" + i + " [label=\"" + Utils.backQuoteChars((String)split.comparisonString(i, this.m_trainInstances)) + "\"]\n");
                this.graphTraverse(child, text, split.orderAdded, i, split.instancesDownBranch(i, instances));
            }
        }
    }

    public String legend() {
        Attribute classAttribute = null;
        if (this.m_trainInstances == null) {
            return "";
        }
        try {
            classAttribute = this.m_trainInstances.classAttribute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "-ve = " + classAttribute.value(0) + ", +ve = " + classAttribute.value(1);
    }

    public String numOfBoostingIterationsTipText() {
        return "Sets the number of boosting iterations to perform. You will need to manually tune this parameter to suit the dataset and the desired complexity/accuracy tradeoff. More boosting iterations will result in larger (potentially more  accurate) trees, but will make learning slower. Each iteration will add 3 nodes (1 split + 2 prediction) to the tree unless merging occurs.";
    }

    public int getNumOfBoostingIterations() {
        return this.m_boostingIterations;
    }

    public void setNumOfBoostingIterations(int b) {
        this.m_boostingIterations = b;
    }

    public String searchPathTipText() {
        return "Sets the type of search to perform when building the tree. The default option (Expand all paths) will do an exhaustive search. The other search methods are heuristic, so they are not guaranteed to find an optimal solution but they are much faster. Expand the heaviest path: searches the path with the most heavily weighted instances. Expand the best z-pure path: searches the path determined by the best z-pure estimate. Expand a random path: the fastest method, simply searches down a single random path on each iteration.";
    }

    public SelectedTag getSearchPath() {
        return new SelectedTag(this.m_searchPath, TAGS_SEARCHPATH);
    }

    public void setSearchPath(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_SEARCHPATH) {
            this.m_searchPath = newMethod.getSelectedTag().getID();
        }
    }

    public String saveInstanceDataTipText() {
        return "Sets whether the tree is to save instance data - the model will take up more memory if it does. If enabled you will be able to visualize the instances at the prediction nodes when visualizing the tree.";
    }

    public boolean getSaveInstanceData() {
        return this.m_saveInstanceData;
    }

    public void setSaveInstanceData(boolean v) {
        this.m_saveInstanceData = v;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> newVector = new Vector<Object>(3);
        newVector.addElement(new Option("\tNumber of boosting iterations.\n\t(Default = 10)", "B", 1, "-B <number of boosting iterations>"));
        newVector.addElement(new Option("\tExpand nodes: -3(all), -2(weight), -1(z_pure), >=0 seed for random walk\n\t(Default = -3)", "E", 1, "-E <-3|-2|-1|>=0>"));
        newVector.addElement(new Option("\tSave the instance data with the model", "D", 0, "-D"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String eString;
        String bString = Utils.getOption((char)'B', (String[])options);
        if (bString.length() != 0) {
            this.setNumOfBoostingIterations(Integer.parseInt(bString));
        }
        if ((eString = Utils.getOption((char)'E', (String[])options)).length() != 0) {
            int value = Integer.parseInt(eString);
            if (value >= 0) {
                this.setSearchPath(new SelectedTag(3, TAGS_SEARCHPATH));
                this.setSeed(value);
            } else {
                this.setSearchPath(new SelectedTag(value + 3, TAGS_SEARCHPATH));
            }
        }
        this.setSaveInstanceData(Utils.getFlag((char)'D', (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-B");
        options.add("" + this.getNumOfBoostingIterations());
        options.add("-E");
        options.add("" + (this.m_searchPath == 3 ? this.m_Seed : this.m_searchPath - 3));
        if (this.getSaveInstanceData()) {
            options.add("-D");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public double measureTreeSize() {
        return this.numOfAllNodes(this.m_root);
    }

    public double measureNumLeaves() {
        return this.numOfPredictionNodes(this.m_root);
    }

    public double measureNumPredictionLeaves() {
        return this.numOfPredictionLeafNodes(this.m_root);
    }

    public double measureNodesExpanded() {
        return this.m_nodesExpanded;
    }

    public double measureExamplesProcessed() {
        return this.m_examplesCounted;
    }

    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(5);
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureNumPredictionLeaves");
        newVector.addElement("measureNodesExpanded");
        newVector.addElement("measureExamplesProcessed");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureTreeSize")) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumLeaves")) {
            return this.measureNumLeaves();
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumPredictionLeaves")) {
            return this.measureNumPredictionLeaves();
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNodesExpanded")) {
            return this.measureNodesExpanded();
        }
        if (additionalMeasureName.equalsIgnoreCase("measureExamplesProcessed")) {
            return this.measureExamplesProcessed();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (ADTree)");
    }

    protected int numOfAllNodes(PredictionNode root) {
        int numSoFar = 0;
        if (root != null) {
            ++numSoFar;
            Enumeration<Splitter> e = root.children();
            while (e.hasMoreElements()) {
                ++numSoFar;
                Splitter split = e.nextElement();
                for (int i = 0; i < split.getNumOfBranches(); ++i) {
                    numSoFar += this.numOfAllNodes(split.getChildForBranch(i));
                }
            }
        }
        return numSoFar;
    }

    protected int numOfPredictionNodes(PredictionNode root) {
        int numSoFar = 0;
        if (root != null) {
            ++numSoFar;
            Enumeration<Splitter> e = root.children();
            while (e.hasMoreElements()) {
                Splitter split = e.nextElement();
                for (int i = 0; i < split.getNumOfBranches(); ++i) {
                    numSoFar += this.numOfPredictionNodes(split.getChildForBranch(i));
                }
            }
        }
        return numSoFar;
    }

    protected int numOfPredictionLeafNodes(PredictionNode root) {
        int numSoFar = 0;
        if (root.getChildren().size() > 0) {
            Enumeration<Splitter> e = root.children();
            while (e.hasMoreElements()) {
                Splitter split = e.nextElement();
                for (int i = 0; i < split.getNumOfBranches(); ++i) {
                    numSoFar += this.numOfPredictionLeafNodes(split.getChildForBranch(i));
                }
            }
        } else {
            numSoFar = 1;
        }
        return numSoFar;
    }

    protected int getRandom(int max) {
        return this.m_random.nextInt(max);
    }

    public int nextSplitAddedOrder() {
        return ++this.m_lastAddedSplitNum;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.initializeClassifier(instances);
        for (int T = 0; T < this.m_boostingIterations; ++T) {
            this.boost();
        }
        if (!this.m_saveInstanceData) {
            this.done();
        }
    }

    public void done() {
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
        this.m_random = null;
        this.m_numericAttIndices = null;
        this.m_nominalAttIndices = null;
        this.m_posTrainInstances = null;
        this.m_negTrainInstances = null;
    }

    public Object clone() {
        ADTree clone = new ADTree();
        if (this.m_root != null) {
            clone.m_root = (PredictionNode)this.m_root.clone();
            clone.m_trainInstances = new Instances(this.m_trainInstances);
            if (this.m_random != null) {
                SerializedObject randomSerial = null;
                try {
                    randomSerial = new SerializedObject((Object)this.m_random);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                clone.m_random = (Random)randomSerial.getObject();
            }
            clone.m_lastAddedSplitNum = this.m_lastAddedSplitNum;
            clone.m_numericAttIndices = this.m_numericAttIndices;
            clone.m_nominalAttIndices = this.m_nominalAttIndices;
            clone.m_trainTotalWeight = this.m_trainTotalWeight;
            if (this.m_posTrainInstances != null) {
                clone.m_posTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_posTrainInstances.numInstances());
                clone.m_negTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_negTrainInstances.numInstances());
                Iterator i$ = clone.m_trainInstances.iterator();
                while (i$.hasNext()) {
                    Instance instance;
                    Instance inst = instance = (Instance)i$.next();
                    try {
                        if ((int)inst.classValue() == 0) {
                            clone.m_negTrainInstances.addReference(inst);
                            continue;
                        }
                        clone.m_posTrainInstances.addReference(inst);
                    }
                    catch (Exception ignored) {}
                }
            }
        }
        clone.m_nodesExpanded = this.m_nodesExpanded;
        clone.m_examplesCounted = this.m_examplesCounted;
        clone.m_boostingIterations = this.m_boostingIterations;
        clone.m_searchPath = this.m_searchPath;
        clone.m_Seed = this.m_Seed;
        return clone;
    }

    public void merge(ADTree mergeWith) throws Exception {
        if (this.m_root == null || mergeWith.m_root == null) {
            throw new Exception("Trying to merge an uninitialized tree");
        }
        this.m_root.merge(mergeWith.m_root, this);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10887 $");
    }

    public static void main(String[] argv) {
        ADTree.runClassifier((Classifier)new ADTree(), (String[])argv);
    }
}

