/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class TwoWayNumericSplit
extends Splitter {
    private static final long serialVersionUID = 449769177903158283L;
    private final int attIndex;
    private final double splitPoint;
    private final PredictionNode[] children;

    public TwoWayNumericSplit(int _attIndex, double _splitPoint) {
        this.attIndex = _attIndex;
        this.splitPoint = _splitPoint;
        this.children = new PredictionNode[2];
    }

    @Override
    public int getNumOfBranches() {
        return 2;
    }

    @Override
    public int branchInstanceGoesDown(Instance inst) {
        if (inst.isMissing(this.attIndex)) {
            return -1;
        }
        if (inst.value(this.attIndex) < this.splitPoint) {
            return 0;
        }
        return 1;
    }

    @Override
    public ReferenceInstances instancesDownBranch(int branch, Instances instances) {
        ReferenceInstances filteredInstances = new ReferenceInstances(instances, 1);
        if (branch == -1) {
            for (Instance instance : instances) {
                Instance inst = instance;
                if (!inst.isMissing(this.attIndex)) continue;
                filteredInstances.addReference(inst);
            }
        } else if (branch == 0) {
            for (Instance instance : instances) {
                Instance inst = instance;
                if (inst.isMissing(this.attIndex) || !(inst.value(this.attIndex) < this.splitPoint)) continue;
                filteredInstances.addReference(inst);
            }
        } else {
            for (Instance instance : instances) {
                Instance inst = instance;
                if (inst.isMissing(this.attIndex) || !(inst.value(this.attIndex) >= this.splitPoint)) continue;
                filteredInstances.addReference(inst);
            }
        }
        return filteredInstances;
    }

    @Override
    public String attributeString(Instances dataset) {
        return dataset.attribute(this.attIndex).name();
    }

    @Override
    public String comparisonString(int branchNum, Instances dataset) {
        return (branchNum == 0 ? "< " : ">= ") + Utils.doubleToString((double)this.splitPoint, (int)3);
    }

    @Override
    public boolean equalTo(Splitter compare) {
        if (compare instanceof TwoWayNumericSplit) {
            TwoWayNumericSplit compareSame = (TwoWayNumericSplit)compare;
            return this.attIndex == compareSame.attIndex && this.splitPoint == compareSame.splitPoint;
        }
        return false;
    }

    @Override
    public void setChildForBranch(int branchNum, PredictionNode childPredictor) {
        this.children[branchNum] = childPredictor;
    }

    @Override
    public PredictionNode getChildForBranch(int branchNum) {
        return this.children[branchNum];
    }

    @Override
    public Object clone() {
        TwoWayNumericSplit clone = new TwoWayNumericSplit(this.attIndex, this.splitPoint);
        clone.orderAdded = this.orderAdded;
        if (this.children[0] != null) {
            clone.setChildForBranch(0, (PredictionNode)this.children[0].clone());
        }
        if (this.children[1] != null) {
            clone.setChildForBranch(1, (PredictionNode)this.children[1].clone());
        }
        return clone;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10324 $");
    }
}

