/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.evl.EvlFix;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class EvlFixInstance {
    protected EvlFix fix;
    protected Object self;
    protected IEvlContext context;
    protected FrameStack scope;
    protected String title = null;

    public IEvlContext getContext() {
        return this.context;
    }

    public EvlFixInstance(IEvlContext context) {
        this.context = context;
        this.scope = context.getFrameStack().clone();
    }

    public EvlFix getFix() {
        return this.fix;
    }

    public void setFix(EvlFix fix) {
        this.fix = fix;
    }

    public Object getSelf() {
        return this.self;
    }

    public void setSelf(Object self) {
        this.self = self;
    }

    public String getTitle() throws EolRuntimeException {
        if (this.title == null) {
            try {
                FrameStack oldScope = this.context.getFrameStack();
                this.context.setFrameStack(this.scope);
                this.title = this.fix.getTitle(this.self, this.context);
                this.context.setFrameStack(oldScope);
            }
            catch (EolRuntimeException ex) {
                this.title = "<error>";
                throw ex;
            }
        }
        return this.title;
    }

    public void perform() throws EolRuntimeException {
        FrameStack oldScope = this.context.getFrameStack();
        this.context.setFrameStack(this.scope);
        try {
            try {
                this.context.getModelRepository().getTransactionSupport().startTransaction();
                this.fix.execute(this.self, this.context);
                this.context.getModelRepository().getTransactionSupport().commitTransaction();
            }
            catch (EolRuntimeException ex) {
                this.context.getModelRepository().getTransactionSupport().rollbackTransaction();
                throw ex;
            }
        }
        finally {
            this.context.setFrameStack(oldScope);
        }
    }

    public String toString() {
        try {
            return this.getTitle();
        }
        catch (EolRuntimeException e) {
            this.context.getErrorStream().println(e.getMessage());
            return "An exception occured while evaluating the title of the fix";
        }
    }
}

