/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.ErrorRatio;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.R2;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractAlgorithmRunner {
    public static void printFinalSolutionSet(List<? extends Solution<?>> population) {
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }

    public static void printQualityIndicators(List<? extends Solution<?>> population, String paretoFrontFile) throws FileNotFoundException {
        ArrayFront referenceFront = new ArrayFront(paretoFrontFile);
        FrontNormalizer frontNormalizer = new FrontNormalizer(referenceFront);
        Front normalizedReferenceFront = frontNormalizer.normalize(referenceFront);
        Front normalizedFront = frontNormalizer.normalize(new ArrayFront(population));
        List<DoubleSolution> normalizedPopulation = FrontUtils.convertFrontToSolutionList(normalizedFront);
        String outputString = "\n";
        outputString = outputString + "Hypervolume (N) : " + new Hypervolume<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Hypervolume     : " + new Hypervolume(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Epsilon (N)     : " + new Epsilon<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Epsilon         : " + new Epsilon(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "GD (N)          : " + new GenerationalDistance<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "GD              : " + new GenerationalDistance(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "IGD (N)         : " + new InvertedGenerationalDistance<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "IGD             : " + new InvertedGenerationalDistance(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "IGD+ (N)        : " + new InvertedGenerationalDistancePlus<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "IGD+            : " + new InvertedGenerationalDistancePlus(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Spread (N)      : " + new Spread<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Spread          : " + new Spread(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "R2 (N)          : " + new R2<List<DoubleSolution>>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "R2              : " + new R2(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Error ratio     : " + new ErrorRatio(referenceFront).evaluate(population) + "\n";
        JMetalLogger.logger.info(outputString);
    }
}

