/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class ClassOrder
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -2116226838887628411L;
    private long m_Seed = 1L;
    private Random m_Random = null;
    private int[] m_Converter = null;
    private Attribute m_ClassAttribute = null;
    private int m_ClassOrder = 0;
    public static final int FREQ_ASCEND = 0;
    public static final int FREQ_DESCEND = 1;
    public static final int RANDOM = 2;
    private double[] m_ClassCounts = null;

    public String globalInfo() {
        return "Changes the order of the classes so that the class values are no longer of in the order specified in the header. The values will be in the order specified by the user -- it could be either in ascending/descending order by the class frequency or in random order. Note that this filter currently does not change the header, only the class values of the instances, so there is not much point in using it in conjunction with the FilteredClassifier. The value can also be converted back using 'originalValue(double value)' procedure.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecify the seed of randomization\n\tused to randomize the class\n\torder (default: 1)", "R", 1, "-R <seed>"));
        newVector.addElement(new Option("\tSpecify the class order to be\n\tsorted, could be 0: ascending\n\t1: descending and 2: random.(default: 0)", "C", 1, "-C <order>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seedString = Utils.getOption('R', options);
        this.m_Seed = seedString.length() != 0 ? Long.parseLong(seedString) : 1L;
        String orderString = Utils.getOption('C', options);
        this.m_ClassOrder = orderString.length() != 0 ? Integer.parseInt(orderString) : 0;
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        this.m_Random = null;
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-R");
        options.add("" + this.m_Seed);
        options.add("-C");
        options.add("" + this.m_ClassOrder);
        return options.toArray(new String[0]);
    }

    public String seedTipText() {
        return "Specify the seed of randomization of the class order";
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public void setSeed(long seed) {
        this.m_Seed = seed;
        this.m_Random = null;
    }

    public String classOrderTipText() {
        return "Specify the class order after the filtering";
    }

    public int getClassOrder() {
        return this.m_ClassOrder;
    }

    public void setClassOrder(int order) {
        this.m_ClassOrder = order;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(new Instances(instanceInfo, 0));
        this.m_ClassAttribute = instanceInfo.classAttribute();
        this.m_Random = new Random(this.m_Seed);
        this.m_Converter = null;
        int numClasses = instanceInfo.numClasses();
        this.m_ClassCounts = new double[numClasses];
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Converter != null) {
            Instance datum = (Instance)instance.copy();
            if (!datum.isMissing(this.m_ClassAttribute)) {
                datum.setClassValue(this.m_Converter[(int)datum.classValue()]);
            }
            this.push(datum);
            return true;
        }
        if (!instance.isMissing(this.m_ClassAttribute)) {
            int n = (int)instance.classValue();
            this.m_ClassCounts[n] = this.m_ClassCounts[n] + instance.weight();
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() throws Exception {
        Instances data = this.getInputFormat();
        if (data == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Converter == null) {
            int i;
            int i2;
            int[] randomIndices = new int[this.m_ClassCounts.length];
            int i3 = 0;
            while (i3 < randomIndices.length) {
                randomIndices[i3] = i3;
                ++i3;
            }
            int j = randomIndices.length - 1;
            while (j > 0) {
                int toSwap = this.m_Random.nextInt(j + 1);
                int tmpIndex = randomIndices[j];
                randomIndices[j] = randomIndices[toSwap];
                randomIndices[toSwap] = tmpIndex;
                --j;
            }
            double[] randomizedCounts = new double[this.m_ClassCounts.length];
            int i4 = 0;
            while (i4 < randomizedCounts.length) {
                randomizedCounts[i4] = this.m_ClassCounts[randomIndices[i4]];
                ++i4;
            }
            if (this.m_ClassOrder == 2) {
                this.m_Converter = randomIndices;
                this.m_ClassCounts = randomizedCounts;
            } else {
                int[] sorted = Utils.sort(randomizedCounts);
                this.m_Converter = new int[sorted.length];
                if (this.m_ClassOrder == 0) {
                    i2 = 0;
                    while (i2 < sorted.length) {
                        this.m_Converter[i2] = randomIndices[sorted[i2]];
                        ++i2;
                    }
                } else if (this.m_ClassOrder == 1) {
                    i2 = 0;
                    while (i2 < sorted.length) {
                        this.m_Converter[i2] = randomIndices[sorted[sorted.length - i2 - 1]];
                        ++i2;
                    }
                } else {
                    throw new IllegalArgumentException("Class order not defined!");
                }
                double[] tmp2 = new double[this.m_ClassCounts.length];
                i = 0;
                while (i < this.m_Converter.length) {
                    tmp2[i] = this.m_ClassCounts[this.m_Converter[i]];
                    ++i;
                }
                this.m_ClassCounts = tmp2;
            }
            ArrayList<String> values = new ArrayList<String>(data.classAttribute().numValues());
            i2 = 0;
            while (i2 < data.numClasses()) {
                values.add(data.classAttribute().value(this.m_Converter[i2]));
                ++i2;
            }
            ArrayList<Attribute> newVec = new ArrayList<Attribute>(data.numAttributes());
            i = 0;
            while (i < data.numAttributes()) {
                if (i == data.classIndex()) {
                    newVec.add(new Attribute(data.classAttribute().name(), values, data.classAttribute().getMetadata()));
                } else {
                    newVec.add(data.attribute(i));
                }
                ++i;
            }
            Instances newInsts = new Instances(data.relationName(), newVec, 0);
            newInsts.setClassIndex(data.classIndex());
            this.setOutputFormat(newInsts);
            int[] temp = new int[this.m_Converter.length];
            int i5 = 0;
            while (i5 < temp.length) {
                temp[this.m_Converter[i5]] = i5;
                ++i5;
            }
            this.m_Converter = temp;
            int xyz = 0;
            while (xyz < data.numInstances()) {
                Instance datum = data.instance(xyz);
                if (!datum.isMissing(datum.classIndex())) {
                    datum.setClassValue(this.m_Converter[(int)datum.classValue()]);
                }
                this.push(datum);
                ++xyz;
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public double[] getClassCounts() {
        if (this.m_ClassAttribute.isNominal()) {
            return this.m_ClassCounts;
        }
        return null;
    }

    public double[] distributionsByOriginalIndex(double[] before) {
        double[] after = new double[this.m_Converter.length];
        int i = 0;
        while (i < this.m_Converter.length) {
            after[i] = before[this.m_Converter[i]];
            ++i;
        }
        return after;
    }

    public double originalValue(double value) throws Exception {
        if (this.m_Converter == null) {
            throw new IllegalStateException("Coverter table not defined yet!");
        }
        int i = 0;
        while (i < this.m_Converter.length) {
            if ((int)value == this.m_Converter[i]) {
                return i;
            }
            ++i;
        }
        return -1.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        ClassOrder.runFilter(new ClassOrder(), argv);
    }
}

