/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.misc.InputMappedClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Drawable;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ConfigurationListener;
import weka.gui.beans.ConfigurationProducer;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.SerializedModelSaver;
import weka.gui.beans.StreamThroughput;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Classifier
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
InstanceListener,
ConfigurationProducer,
EnvironmentHandler {
    private static final long serialVersionUID = 659603893917736008L;
    protected BeanVisual m_visual = new BeanVisual("Classifier", "weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private int m_state = IDLE;
    protected String m_globalInfo;
    protected HashMap<String, List<Object>> m_listenees = new HashMap();
    private final Vector<BatchClassifierListener> m_batchClassifierListeners = new Vector();
    private final Vector<IncrementalClassifierListener> m_incrementalClassifierListeners = new Vector();
    private final Vector<GraphListener> m_graphListeners = new Vector();
    private final Vector<TextListener> m_textListeners = new Vector();
    private Instances m_trainingSet;
    private weka.classifiers.Classifier m_Classifier;
    private weka.classifiers.Classifier m_ClassifierTemplate = this.m_Classifier = new ZeroR();
    private final IncrementalClassifierEvent m_ie = new IncrementalClassifierEvent(this);
    public static final String FILE_EXTENSION = "model";
    private transient JFileChooser m_fileChooser = null;
    protected FileFilter m_binaryFilter = new ExtensionFileFilter(".model", "Binary serialized model file (*model)");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".komlmodel", "XML serialized model file (*.komlmodel)");
    protected FileFilter m_XStreamFilter = new ExtensionFileFilter(".xstreammodel", "XML serialized model file (*.xstreammodel)");
    protected transient Environment m_env;
    private boolean m_resetIncrementalClassifier = false;
    private boolean m_updateIncrementalClassifier = true;
    private transient Logger m_log = null;
    private InstanceEvent m_incrementalEvent;
    protected int m_executionSlots = 2;
    protected transient ThreadPoolExecutor m_executorPool;
    protected transient BatchClassifierEvent[][] m_outputQueues;
    protected transient boolean[][] m_completedSets;
    protected transient Date m_currentBatchIdentifier;
    protected transient boolean m_batchStarted = false;
    protected String m_oldText = "";
    protected boolean m_reject = false;
    protected boolean m_block = false;
    protected String m_loadModelFileName = "";
    protected transient StreamThroughput m_throughput;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Classifier() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClassifierTemplate(this.m_ClassifierTemplate);
    }

    private void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_executionSlots, this.m_executionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    protected void setupFileChooser() {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        }
        this.m_fileChooser.addChoosableFileFilter(this.m_binaryFilter);
        if (KOML.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        if (XStream.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_XStreamFilter);
        }
        this.m_fileChooser.setFileFilter(this.m_binaryFilter);
    }

    public int getExecutionSlots() {
        return this.m_executionSlots;
    }

    public void setExecutionSlots(int slots) {
        this.m_executionSlots = slots;
    }

    public void setBlockOnLastFold(boolean block) {
        this.m_block = block;
    }

    public boolean getBlockOnLastFold() {
        return this.m_block;
    }

    public void setClassifierTemplate(weka.classifiers.Classifier c) {
        boolean loadImages = true;
        if (c.getClass().getName().compareTo(this.m_ClassifierTemplate.getClass().getName()) == 0) {
            loadImages = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_ClassifierTemplate = c;
        String classifierName = c.getClass().toString();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        if (loadImages) {
            if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + classifierName + ".gif", "weka/gui/beans/icons/" + classifierName + "_animated.gif")) {
                this.useDefaultVisual();
            }
            this.m_visual.setText(classifierName);
        }
        if (!(this.m_ClassifierTemplate instanceof UpdateableClassifier) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " WARNING : " + this.getCustomName() + " is not an incremental classifier");
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_ClassifierTemplate);
        try {
            if (this.m_ClassifierTemplate instanceof InputMappedClassifier) {
                this.m_Classifier = AbstractClassifier.makeCopy(this.m_ClassifierTemplate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public weka.classifiers.Classifier getClassifierTemplate() {
        return this.m_ClassifierTemplate;
    }

    private void setTrainedClassifier(weka.classifiers.Classifier tc) throws Exception {
        weka.classifiers.Classifier newTemplate = null;
        String[] options = ((OptionHandler)((Object)tc)).getOptions();
        newTemplate = AbstractClassifier.forName(tc.getClass().getName(), options);
        if (!newTemplate.getClass().equals(this.m_ClassifierTemplate.getClass())) {
            throw new Exception("Classifier model " + tc.getClass().getName() + " is not the same type " + "of classifier as this one (" + this.m_ClassifierTemplate.getClass().getName() + ")");
        }
        this.setClassifierTemplate(newTemplate);
        this.m_Classifier = tc;
    }

    public boolean hasIncomingStreamInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("instance");
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet");
    }

    public weka.classifiers.Classifier getClassifier() {
        return this.m_Classifier;
    }

    @Override
    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.classifiers.Classifier)) {
            throw new IllegalArgumentException(algorithm.getClass() + " : incorrect " + "type of algorithm (Classifier)");
        }
        this.setClassifierTemplate((weka.classifiers.Classifier)algorithm);
    }

    @Override
    public Object getWrappedAlgorithm() {
        return this.getClassifierTemplate();
    }

    public void setLoadClassifierFileName(String filename) {
        this.m_loadModelFileName = filename;
    }

    public String getLoadClassifierFileName() {
        return this.m_loadModelFileName;
    }

    public void setResetIncrementalClassifier(boolean reset) {
        this.m_resetIncrementalClassifier = reset;
    }

    public boolean getResetIncrementalClassifier() {
        return this.m_resetIncrementalClassifier;
    }

    public boolean getUpdateIncrementalClassifier() {
        return this.m_updateIncrementalClassifier;
    }

    public void setUpdateIncrementalClassifier(boolean update) {
        this.m_updateIncrementalClassifier = update;
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        if (this.m_log == null) {
            System.err.println("Log is null");
        }
        this.m_incrementalEvent = e;
        this.handleIncrementalEvent();
    }

    private void handleIncrementalEvent() {
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            String messg = "[Classifier] " + this.statusMessagePrefix() + " is currently batch training!";
            if (this.m_log != null) {
                this.m_log.logMessage(messg);
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: " + "Can't accept instance - batch training in progress.");
            } else {
                System.err.println(messg);
            }
            return;
        }
        if (this.m_incrementalEvent.getStatus() == 0) {
            String msg;
            Instances dataset;
            this.m_throughput = new StreamThroughput(this.statusMessagePrefix());
            if (this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "remove");
            }
            if ((dataset = this.m_incrementalEvent.getStructure()).classIndex() < 0) {
                this.stop();
                String errorMessage = String.valueOf(this.statusMessagePrefix()) + "ERROR: no class attribute set in incoming stream!";
                if (this.m_log != null) {
                    this.m_log.statusMessage(errorMessage);
                    this.m_log.logMessage("[" + this.getCustomName() + "] " + errorMessage);
                } else {
                    System.err.println("[" + this.getCustomName() + "] " + errorMessage);
                }
                return;
            }
            if (this.m_loadModelFileName != null && this.m_loadModelFileName.length() > 0 && this.m_state == IDLE && !this.m_listenees.containsKey("trainingSet")) {
                String resolvedFileName = this.m_loadModelFileName;
                if (this.m_env != null) {
                    try {
                        resolvedFileName = this.m_env.substitute(resolvedFileName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                File loadFrom = new File(resolvedFileName);
                try {
                    this.loadFromFile(loadFrom);
                }
                catch (Exception ex) {
                    this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: unable to load " + "model (see log).");
                    this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + "Problem loading classifier - training from scratch... " + ex.getMessage());
                }
            }
            try {
                if (this.m_trainingSet == null || !this.m_trainingSet.equalHeaders(dataset) || this.m_resetIncrementalClassifier) {
                    if (!(this.m_ClassifierTemplate instanceof UpdateableClassifier) && !(this.m_ClassifierTemplate instanceof InputMappedClassifier)) {
                        this.stop();
                        if (this.m_log != null) {
                            msg = this.m_trainingSet == null ? String.valueOf(this.statusMessagePrefix()) + "ERROR: classifier has not been batch " + "trained; can't process instance events." : String.valueOf(this.statusMessagePrefix()) + "ERROR: instance event's structure is different from " + "the data that " + "was used to batch train this classifier; can't continue.";
                            this.m_log.logMessage("[Classifier] " + msg);
                            this.m_log.statusMessage(msg);
                        }
                        return;
                    }
                    if (this.m_ClassifierTemplate instanceof InputMappedClassifier) {
                        this.m_trainingSet = ((InputMappedClassifier)this.m_Classifier).getModelHeader(this.m_trainingSet);
                    }
                    if (this.m_trainingSet != null && !dataset.equalHeaders(this.m_trainingSet)) {
                        if (this.m_log != null) {
                            msg = String.valueOf(this.statusMessagePrefix()) + " WARNING : structure of instance events differ " + "from data used in batch training this " + "classifier. Resetting classifier...";
                            this.m_log.logMessage("[Classifier] " + msg);
                            this.m_log.statusMessage(msg);
                        }
                        this.m_trainingSet = null;
                    }
                    if (this.m_resetIncrementalClassifier) {
                        if (this.m_log != null) {
                            msg = String.valueOf(this.statusMessagePrefix()) + " Reseting incremental classifier";
                            this.m_log.logMessage("[Classifier] " + msg);
                            this.m_log.statusMessage(msg);
                        }
                        this.m_trainingSet = null;
                    }
                    if (this.m_trainingSet == null) {
                        this.m_trainingSet = new Instances(dataset, 0);
                        this.m_Classifier = AbstractClassifier.makeCopy(this.m_ClassifierTemplate);
                        if (this.m_Classifier instanceof EnvironmentHandler && this.m_env != null) {
                            ((EnvironmentHandler)((Object)this.m_Classifier)).setEnvironment(this.m_env);
                        }
                        this.m_Classifier.buildClassifier(this.m_trainingSet);
                    }
                }
            }
            catch (Exception ex) {
                this.stop();
                if (this.m_log != null) {
                    this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR (See log for details)");
                    this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " problem during incremental processing. " + ex.getMessage());
                }
                ex.printStackTrace();
                return;
            }
            if (!this.m_incrementalEvent.m_formatNotificationOnly) {
                String string = msg = this.m_updateIncrementalClassifier ? String.valueOf(this.statusMessagePrefix()) + "Training incrementally..." : String.valueOf(this.statusMessagePrefix()) + "Predicting incrementally...";
                if (this.m_log != null) {
                    this.m_log.statusMessage(msg);
                }
            }
            System.err.println("NOTIFYING NEW BATCH");
            this.m_ie.setStructure(dataset);
            this.m_ie.setClassifier(this.m_Classifier);
            this.notifyIncrementalClassifierListeners(this.m_ie);
            return;
        }
        if (this.m_trainingSet == null) {
            return;
        }
        try {
            if (this.m_incrementalEvent.getInstance() != null && this.m_incrementalEvent.getInstance().dataset().classIndex() < 0) {
                this.m_incrementalEvent.getInstance().dataset().setClassIndex(this.m_incrementalEvent.getInstance().dataset().numAttributes() - 1);
            }
            int status = 1;
            if (this.m_incrementalEvent.getStatus() == 2 || this.m_incrementalEvent.getInstance() == null) {
                status = 2;
            }
            if (this.m_incrementalEvent.getInstance() != null) {
                this.m_throughput.updateStart();
            }
            this.m_ie.setStatus(status);
            this.m_ie.setClassifier(this.m_Classifier);
            this.m_ie.setCurrentInstance(this.m_incrementalEvent.getInstance());
            this.notifyIncrementalClassifierListeners(this.m_ie);
            if (this.m_ClassifierTemplate instanceof UpdateableClassifier && this.m_updateIncrementalClassifier && this.m_incrementalEvent.getInstance() != null && !this.m_incrementalEvent.getInstance().isMissing(this.m_incrementalEvent.getInstance().dataset().classIndex())) {
                ((UpdateableClassifier)((Object)this.m_Classifier)).updateClassifier(this.m_incrementalEvent.getInstance());
            }
            if (this.m_incrementalEvent.getInstance() != null) {
                this.m_throughput.updateEnd(this.m_log);
            }
            if (this.m_incrementalEvent.getStatus() == 2 || this.m_incrementalEvent.getInstance() == null) {
                if (this.m_textListeners.size() > 0) {
                    String modelString = this.m_Classifier.toString();
                    String titleString = this.m_Classifier.getClass().getName();
                    titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                    modelString = "=== Classifier model ===\n\nScheme:   " + titleString + "\n" + "Relation: " + this.m_trainingSet.relationName() + "\n\n" + modelString;
                    titleString = "Model: " + titleString;
                    TextEvent nt = new TextEvent(this, modelString, titleString);
                    this.notifyTextListeners(nt);
                }
                this.m_throughput.finished(this.m_log);
            }
        }
        catch (Exception ex) {
            this.stop();
            if (this.m_log != null) {
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + ex.getMessage());
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR (see log for details)");
                ex.printStackTrace();
            }
            ex.printStackTrace();
        }
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        if (e.isStructureOnly()) {
            BatchClassifierEvent ce = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, e.getTrainingSet()), new DataSetEvent(this, e.getTrainingSet()), e.getSetNumber(), e.getMaxSetNumber());
            this.notifyBatchClassifierListeners(ce);
            return;
        }
        if (this.m_reject) {
            if (this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "BUSY. Can't accept data " + "at this time.");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " BUSY. Can't accept data at this time.");
            }
            return;
        }
        if (e.getRunNumber() == 1 && e.getSetNumber() == 1) {
            this.m_trainingSet = new Instances(e.getTrainingSet(), 0);
            this.m_state = BUILDING_MODEL;
            String msg = "[Classifier] " + this.statusMessagePrefix() + " starting executor pool (" + this.getExecutionSlots() + " slots)...";
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            this.startExecutorPool();
            msg = "[Classifier] " + this.statusMessagePrefix() + " setup output queues.";
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (!this.m_batchStarted) {
                this.m_outputQueues = new BatchClassifierEvent[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_completedSets = new boolean[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_currentBatchIdentifier = new Date();
                this.m_batchStarted = true;
            }
        }
        TrainingTask newTask = new TrainingTask(e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber(), e.getTrainingSet());
        String msg = "[Classifier] " + this.statusMessagePrefix() + " scheduling run " + e.getRunNumber() + " fold " + e.getSetNumber() + " for execution...";
        if (this.m_log != null) {
            this.m_log.logMessage(msg);
        } else {
            System.err.println(msg);
        }
        this.m_executorPool.execute(newTask);
    }

    @Override
    public synchronized void acceptTestSet(TestSetEvent e) {
        weka.classifiers.Classifier classifierToUse;
        if (this.m_reject) {
            if (this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "BUSY. Can't accept data " + "at this time.");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " BUSY. Can't accept data at this time.");
            }
            return;
        }
        Instances testSet = e.getTestSet();
        if (testSet != null && testSet.classIndex() < 0) {
            this.stop();
            String errorMessage = String.valueOf(this.statusMessagePrefix()) + "ERROR: no class attribute set in test data!";
            if (this.m_log != null) {
                this.m_log.statusMessage(errorMessage);
                this.m_log.logMessage("[Classifier] " + errorMessage);
            } else {
                System.err.println("[Classifier] " + errorMessage);
            }
            return;
        }
        if (this.m_loadModelFileName != null && this.m_loadModelFileName.length() > 0 && this.m_state == IDLE && !this.m_listenees.containsKey("trainingSet") && e.getMaxRunNumber() == 1 && e.getMaxSetNumber() == 1) {
            String resolvedFileName = this.m_loadModelFileName;
            if (this.m_env != null) {
                try {
                    resolvedFileName = this.m_env.substitute(resolvedFileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            File loadFrom = new File(resolvedFileName);
            try {
                this.loadFromFile(loadFrom);
            }
            catch (Exception ex) {
                this.stop();
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR: unable to load " + "model (see log).");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + "Problem loading classifier. " + ex.getMessage());
                return;
            }
        }
        if ((classifierToUse = this.m_Classifier) != null && this.m_state == IDLE && !this.m_listenees.containsKey("trainingSet")) {
            if (e.getTestSet() != null && e.isStructureOnly()) {
                return;
            }
            if (classifierToUse instanceof EnvironmentHandler && this.m_env != null) {
                ((EnvironmentHandler)((Object)classifierToUse)).setEnvironment(this.m_env);
            }
            if (classifierToUse instanceof InputMappedClassifier) {
                try {
                    this.m_trainingSet = ((InputMappedClassifier)classifierToUse).getModelHeader(this.m_trainingSet);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (this.m_trainingSet == null) {
                this.stop();
                String errorMessage = String.valueOf(this.statusMessagePrefix()) + "ERROR: no trained/loaded classifier to use for prediction!";
                if (this.m_log != null) {
                    this.m_log.statusMessage(errorMessage);
                    this.m_log.logMessage("[Classifier] " + errorMessage);
                } else {
                    System.err.println("[Classifier] " + errorMessage);
                }
                return;
            }
            testSet = e.getTestSet();
            if (e.getRunNumber() == 1 && e.getSetNumber() == 1) {
                this.m_currentBatchIdentifier = new Date();
            }
            if (testSet != null) {
                if (!this.m_trainingSet.equalHeaders(testSet) && !(classifierToUse instanceof InputMappedClassifier)) {
                    boolean wrapClassifier = false;
                    if (!Utils.getDontShowDialog("weka.gui.beans.Classifier.AutoWrapInInputMappedClassifier")) {
                        if (!GraphicsEnvironment.isHeadless()) {
                            JCheckBox dontShow = new JCheckBox("Do not show this message again");
                            Object[] stuff = new Object[]{"Data used to train model and test set are not compatible.\nWould you like to automatically wrap the classifier in\nan \"InputMappedClassifier\" before proceeding?.\n", dontShow};
                            int result = JOptionPane.showConfirmDialog(this, stuff, "KnowledgeFlow:Classifier", 0);
                            if (result == 0) {
                                wrapClassifier = true;
                            }
                            if (dontShow.isSelected()) {
                                String response = wrapClassifier ? "yes" : "no";
                                try {
                                    Utils.setDontShowDialogResponse("weka.gui.explorer.ClassifierPanel.AutoWrapInInputMappedClassifier", response);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        } else {
                            wrapClassifier = true;
                        }
                    } else {
                        try {
                            String response = Utils.getDontShowDialogResponse("weka.gui.explorer.ClassifierPanel.AutoWrapInInputMappedClassifier");
                            if (response != null && response.equalsIgnoreCase("yes")) {
                                wrapClassifier = true;
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (wrapClassifier) {
                        InputMappedClassifier temp = new InputMappedClassifier();
                        temp.setClassifier(classifierToUse);
                        temp.setModelHeader(new Instances(this.m_trainingSet, 0));
                        classifierToUse = temp;
                    }
                }
                if (this.m_trainingSet.equalHeaders(testSet) || classifierToUse instanceof InputMappedClassifier) {
                    BatchClassifierEvent ce = new BatchClassifierEvent(this, classifierToUse, new DataSetEvent(this, this.m_trainingSet), new DataSetEvent(this, e.getTestSet()), e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber());
                    ce.setGroupIdentifier(this.m_currentBatchIdentifier.getTime());
                    ce.setLabel(this.getCustomName());
                    if (this.m_log != null && !e.isStructureOnly()) {
                        this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Finished.");
                    }
                    this.m_batchStarted = false;
                    this.notifyBatchClassifierListeners(ce);
                } else if (testSet.numInstances() > 0 && testSet.classIndex() == this.m_trainingSet.classIndex() && testSet.attributeStats((int)testSet.classIndex()).missingCount == testSet.numInstances()) {
                    boolean ok = true;
                    int i = 0;
                    while (i < testSet.numAttributes()) {
                        if (i != testSet.classIndex() && !(ok = testSet.attribute(i).equals(this.m_trainingSet.attribute(i)))) break;
                        ++i;
                    }
                    if (ok) {
                        BatchClassifierEvent ce = new BatchClassifierEvent(this, classifierToUse, new DataSetEvent(this, this.m_trainingSet), new DataSetEvent(this, e.getTestSet()), e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber());
                        ce.setGroupIdentifier(this.m_currentBatchIdentifier.getTime());
                        ce.setLabel(this.getCustomName());
                        if (this.m_log != null && !e.isStructureOnly()) {
                            this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Finished.");
                        }
                        this.m_batchStarted = false;
                        this.notifyBatchClassifierListeners(ce);
                    } else {
                        this.stop();
                        String errorMessage = String.valueOf(this.statusMessagePrefix()) + "ERROR: structure of training and test sets is not compatible!";
                        if (this.m_log != null) {
                            this.m_log.statusMessage(errorMessage);
                            this.m_log.logMessage("[Classifier] " + errorMessage);
                        } else {
                            System.err.println("[Classifier] " + errorMessage);
                        }
                    }
                }
            }
        } else {
            if (e.getRunNumber() == 1 && e.getSetNumber() == 1 && !this.m_batchStarted) {
                this.m_outputQueues = new BatchClassifierEvent[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_completedSets = new boolean[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_currentBatchIdentifier = new Date();
                this.m_batchStarted = true;
            }
            if (this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1] == null) {
                if (!e.isStructureOnly()) {
                    this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1] = new BatchClassifierEvent(this, null, null, new DataSetEvent(this, e.getTestSet()), e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber());
                    this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1].setLabel(this.getCustomName());
                    if (e.getRunNumber() == e.getMaxRunNumber() && e.getSetNumber() == e.getMaxSetNumber() && e.getMaxSetNumber() != 1) {
                        this.m_reject = true;
                        if (this.m_block) {
                            this.block(true);
                        }
                    }
                }
            } else {
                this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1].setTestSet(new DataSetEvent(this, e.getTestSet()));
                this.checkCompletedRun(e.getRunNumber(), e.getMaxRunNumber(), e.getMaxSetNumber());
            }
        }
    }

    private synchronized void classifierTrainingComplete(BatchClassifierEvent ce) {
        if (this.m_listenees.containsKey("testSet")) {
            String msg = "[Classifier] " + this.statusMessagePrefix() + " storing model for run " + ce.getRunNumber() + " fold " + ce.getSetNumber();
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1] == null) {
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1] = ce;
            } else {
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1].setClassifier(ce.getClassifier());
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1].setTrainSet(ce.getTrainSet());
            }
            this.checkCompletedRun(ce.getRunNumber(), ce.getMaxRunNumber(), ce.getMaxSetNumber());
        }
    }

    private synchronized void checkCompletedRun(int runNum, int maxRunNum, int maxSets) {
        int i = 0;
        while (i < maxSets) {
            if (this.m_outputQueues[runNum - 1][i] != null && this.m_outputQueues[runNum - 1][i].getClassifier() != null && this.m_outputQueues[runNum - 1][i].getTestSet() != null) {
                String msg = "[Classifier] " + this.statusMessagePrefix() + " dispatching run/set " + runNum + "/" + (i + 1) + " to listeners.";
                if (this.m_log != null) {
                    this.m_log.logMessage(msg);
                } else {
                    System.err.println(msg);
                }
                this.m_outputQueues[runNum - 1][i].setGroupIdentifier(this.m_currentBatchIdentifier.getTime());
                this.m_outputQueues[runNum - 1][i].setLabel(this.getCustomName());
                this.notifyBatchClassifierListeners(this.m_outputQueues[runNum - 1][i]);
                this.m_outputQueues[runNum - 1][i] = null;
                this.m_completedSets[runNum - 1][i] = true;
            }
            ++i;
        }
        boolean done = true;
        int i2 = 0;
        while (i2 < maxRunNum) {
            int j = 0;
            while (j < maxSets) {
                if (!this.m_completedSets[i2][j]) {
                    done = false;
                    break;
                }
                ++j;
            }
            if (!done) break;
            ++i2;
        }
        if (done) {
            String msg = "[Classifier] " + this.statusMessagePrefix() + " last classifier unblocking...";
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Finished.");
            }
            this.m_reject = false;
            this.m_batchStarted = false;
            this.block(false);
            this.m_state = IDLE;
        }
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        String name = this.m_ClassifierTemplate.getClass().toString();
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (!this.m_visual.loadIcons("weka/gui/beans/icons/Default_" + (packageName = packageName.substring(packageName.lastIndexOf(46) + 1, packageName.length())) + "Classifier.gif", "weka/gui/beans/icons/Default_" + packageName + "Classifier_animated.gif")) {
            this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
        }
    }

    public synchronized void addBatchClassifierListener(BatchClassifierListener cl) {
        this.m_batchClassifierListeners.addElement(cl);
    }

    public synchronized void removeBatchClassifierListener(BatchClassifierListener cl) {
        this.m_batchClassifierListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyBatchClassifierListeners(BatchClassifierEvent ce) {
        Vector l;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_batchClassifierListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                block10: {
                    if (l.size() > 1) {
                        try {
                            weka.classifiers.Classifier newC = AbstractClassifier.makeCopy(ce.getClassifier());
                            BatchClassifierEvent ne = new BatchClassifierEvent(this, newC, ce.getTrainSet(), ce.getTestSet(), ce.getRunNumber(), ce.getMaxRunNumber(), ce.getSetNumber(), ce.getMaxSetNumber());
                            ((BatchClassifierListener)l.elementAt(i)).acceptClassifier(ne);
                            break block10;
                        }
                        catch (Exception e) {
                            this.stop();
                            if (this.m_log != null) {
                                String msg = String.valueOf(this.statusMessagePrefix()) + "ERROR: unable to make copy of classifier - see log ";
                                this.m_log.logMessage("[Classifier] " + msg + " (" + e.getMessage() + ")");
                                this.m_log.statusMessage(msg);
                            }
                            e.printStackTrace();
                            break;
                        }
                    }
                    ((BatchClassifierListener)l.elementAt(i)).acceptClassifier(ce);
                }
                ++i;
            }
        }
    }

    public synchronized void addGraphListener(GraphListener cl) {
        this.m_graphListeners.addElement(cl);
    }

    public synchronized void removeGraphListener(GraphListener cl) {
        this.m_graphListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent ge) {
        Vector l;
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_graphListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((GraphListener)l.elementAt(i)).acceptGraph(ge);
                ++i;
            }
        }
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    @Override
    public synchronized void addConfigurationListener(ConfigurationListener cl) {
    }

    @Override
    public synchronized void removeConfigurationListener(ConfigurationListener cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent ge) {
        Vector l;
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((TextListener)l.elementAt(i)).acceptText(ge);
                ++i;
            }
        }
    }

    public synchronized void addIncrementalClassifierListener(IncrementalClassifierListener cl) {
        this.m_incrementalClassifierListeners.add(cl);
    }

    public synchronized void removeIncrementalClassifierListener(IncrementalClassifierListener cl) {
        this.m_incrementalClassifierListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIncrementalClassifierListeners(IncrementalClassifierEvent ce) {
        Vector l;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_incrementalClassifierListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((IncrementalClassifierListener)l.elementAt(i)).acceptClassifier(ce);
                ++i;
            }
        }
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return !eventName.equals("trainingSet") || !this.m_listenees.containsKey(eventName);
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        String msg;
        if (eventName.compareTo("instance") == 0 && !(this.m_ClassifierTemplate instanceof UpdateableClassifier) && this.m_log != null) {
            msg = String.valueOf(this.statusMessagePrefix()) + "WARNING: " + this.m_ClassifierTemplate.getClass().getName() + " Is not an updateable classifier. This " + "classifier will only be evaluated on incoming " + "instance events and not trained on them.";
            this.m_log.logMessage("[Classifier] " + msg);
            this.m_log.statusMessage(msg);
        }
        if (eventName.equals("testSet") && this.m_listenees.containsKey("testSet") && this.m_log != null && !Utils.getDontShowDialog("weka.gui.beans.ClassifierMultipleTestSetConnections") && !GraphicsEnvironment.isHeadless()) {
            msg = "You have more than one incoming test set connection to \n'" + this.getCustomName() + "'. In order for this setup to run properly\n" + "and generate correct evaluation results you MUST execute the flow\n" + "by launching start points sequentially (second play button). In order\n" + "to specify the order you'd like the start points launched in you can\n" + "set the name of each start point (right click on start point and select\n" + "'Set name') to include a number prefix - e.g. '1: load my arff file'.";
            JCheckBox dontShow = new JCheckBox("Do not show this message again");
            Object[] stuff = new Object[]{msg, dontShow};
            JOptionPane.showMessageDialog(null, stuff, "Classifier test connection", 0);
            if (dontShow.isSelected()) {
                try {
                    Utils.setDontShowDialog("weka.gui.beans.ClassifierMultipleTestSetConnections");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.connectionAllowed(eventName)) {
            List<Object> listenee = this.m_listenees.get(eventName);
            if (listenee == null) {
                listenee = new ArrayList<Object>();
                this.m_listenees.put(eventName, listenee);
            }
            listenee.add(source);
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        List<Object> listenees = this.m_listenees.get(eventName);
        if (listenees != null) {
            listenees.remove(source);
            if (listenees.size() == 0) {
                this.m_listenees.remove(eventName);
            }
        }
        if (eventName.compareTo("instance") == 0) {
            this.stop();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public void stop() {
        for (Map.Entry<String, List<Object>> e : this.m_listenees.entrySet()) {
            List<Object> l = e.getValue();
            for (Object o : l) {
                if (!(o instanceof BeanCommon)) continue;
                ((BeanCommon)o).stop();
            }
        }
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
            this.m_executorPool.purge();
            this.m_executorPool = null;
        }
        this.m_reject = false;
        this.m_batchStarted = false;
        this.block(false);
        this.m_visual.setStatic();
        this.m_oldText.length();
    }

    public void loadModel() {
        block11: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((returnVal = this.m_fileChooser.showOpenDialog(this)) == 0) {
                    File loadFrom = this.m_fileChooser.getSelectedFile();
                    if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                        if (!loadFrom.getName().toLowerCase().endsWith(".model")) {
                            loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + "." + FILE_EXTENSION);
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                        if (!loadFrom.getName().toLowerCase().endsWith(".komlmodel")) {
                            loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + ".koml" + FILE_EXTENSION);
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !loadFrom.getName().toLowerCase().endsWith(".xstreammodel")) {
                        loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + ".xstream" + FILE_EXTENSION);
                    }
                    this.loadFromFile(loadFrom);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problem loading classifier.\n" + ex.getMessage(), "Load Model", 0);
                if (this.m_log == null) break block11;
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR: unable to load " + "model (see log).");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + "Problem loading classifier. " + ex.getMessage());
            }
        }
    }

    protected void loadFromFile(File loadFrom) throws Exception {
        weka.classifiers.Classifier temp = null;
        Instances tempHeader = null;
        if (KOML.isPresent() && loadFrom.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
            Vector v = (Vector)KOML.read(loadFrom.getAbsolutePath());
            temp = (weka.classifiers.Classifier)v.elementAt(0);
            if (v.size() == 2) {
                tempHeader = (Instances)v.elementAt(1);
            }
        } else if (XStream.isPresent() && loadFrom.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
            Vector v = (Vector)XStream.read(loadFrom.getAbsolutePath());
            temp = (weka.classifiers.Classifier)v.elementAt(0);
            if (v.size() == 2) {
                tempHeader = (Instances)v.elementAt(1);
            }
        } else {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(loadFrom)));
            temp = (weka.classifiers.Classifier)is.readObject();
            try {
                tempHeader = (Instances)is.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            is.close();
        }
        this.setTrainedClassifier(temp);
        this.m_trainingSet = tempHeader;
        if (this.m_log != null) {
            this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Loaded model.");
            this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + "Loaded classifier: " + this.m_Classifier.getClass().toString() + " from file '" + loadFrom.toString() + "'");
        }
    }

    public void saveModel() {
        block17: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((returnVal = this.m_fileChooser.showSaveDialog(this)) == 0) {
                    File saveTo = this.m_fileChooser.getSelectedFile();
                    String fn = saveTo.getAbsolutePath();
                    if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                        if (!fn.toLowerCase().endsWith(".model")) {
                            fn = String.valueOf(fn) + ".model";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                        if (!fn.toLowerCase().endsWith(".komlmodel")) {
                            fn = String.valueOf(fn) + ".komlmodel";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !fn.toLowerCase().endsWith(".xstreammodel")) {
                        fn = String.valueOf(fn) + ".xstreammodel";
                    }
                    saveTo = new File(fn);
                    if (KOML.isPresent() && saveTo.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
                        SerializedModelSaver.saveKOML(saveTo, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else if (XStream.isPresent() && saveTo.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
                        SerializedModelSaver.saveXStream(saveTo, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else {
                        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveTo)));
                        os.writeObject(this.m_Classifier);
                        if (this.m_trainingSet != null) {
                            Instances header = new Instances(this.m_trainingSet, 0);
                            os.writeObject(header);
                        }
                        os.close();
                    }
                    if (this.m_log != null) {
                        this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "Model saved.");
                        this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " Saved classifier " + this.getCustomName());
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problem saving classifier.\n", "Save Model", 0);
                if (this.m_log == null) break block17;
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR: unable to" + " save model (see log).");
                this.m_log.logMessage("[Classifier] " + this.statusMessagePrefix() + " Problem saving classifier " + this.getCustomName() + ex.getMessage());
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            newVector.addElement("Stop");
        }
        if ((this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) && this.m_Classifier != null) {
            newVector.addElement("Save model");
        }
        if (this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) {
            newVector.addElement("Load model");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") == 0) {
            this.stop();
        } else if (request.compareTo("Save model") == 0) {
            this.saveModel();
        } else if (request.compareTo("Load model") == 0) {
            this.loadModel();
        } else {
            throw new IllegalArgumentException(String.valueOf(request) + " not supported (Classifier)");
        }
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    private boolean generatableEvent(String eventName) {
        return eventName.compareTo("graph") == 0 || eventName.compareTo("text") == 0 || eventName.compareTo("batchClassifier") == 0 || eventName.compareTo("incrementalClassifier") == 0 || eventName.compareTo("configuration") == 0;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        List<Object> source;
        if (!this.generatableEvent(eventName)) {
            return false;
        }
        if (eventName.compareTo("graph") == 0) {
            if (!(this.m_ClassifierTemplate instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source instanceof EventConstraints && !((EventConstraints)((Object)source)).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("batchClassifier") == 0) {
            if (!this.m_listenees.containsKey("testSet") && !this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("testSet");
            if (source instanceof EventConstraints && !((EventConstraints)((Object)source)).eventGeneratable("testSet")) {
                return false;
            }
        }
        if (eventName.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet") && !this.m_listenees.containsKey("instance")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)((Object)source)).eventGeneratable("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("instance");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)((Object)source)).eventGeneratable("instance")) {
                return false;
            }
        }
        if (eventName.compareTo("incrementalClassifier") == 0) {
            if (!this.m_listenees.containsKey("instance")) {
                return false;
            }
            source = this.m_listenees.get("instance");
            if (source instanceof EventConstraints && !((EventConstraints)((Object)source)).eventGeneratable("instance")) {
                return false;
            }
        }
        return !eventName.equals("configuration") || this.m_Classifier != null;
    }

    @Override
    public boolean isBusy() {
        return this.m_executorPool != null && (this.m_executorPool.getQueue().size() != 0 || this.m_executorPool.getActiveCount() != 0 || this.m_state != IDLE);
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|" + (this.m_ClassifierTemplate instanceof OptionHandler && Utils.joinOptions(((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions()).length() > 0 ? String.valueOf(Utils.joinOptions(((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions())) + "|" : "");
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected class TrainingTask
    implements Runnable,
    Task {
        private static final long serialVersionUID = -7918128680624169641L;
        private final int m_runNum;
        private final int m_maxRunNum;
        private final int m_setNum;
        private final int m_maxSetNum;
        private Instances m_train = null;
        private final TaskStatusInfo m_taskInfo = new TaskStatusInfo();

        public TrainingTask(int runNum, int maxRunNum, int setNum, int maxSetNum, Instances train) {
            this.m_runNum = runNum;
            this.m_maxRunNum = maxRunNum;
            this.m_setNum = setNum;
            this.m_maxSetNum = maxSetNum;
            this.m_train = train;
            this.m_taskInfo.setExecutionStatus(0);
        }

        @Override
        public void run() {
            this.execute();
        }

        @Override
        public void execute() {
            block20: {
                try {
                    if (this.m_train == null) break block20;
                    if (this.m_train.classIndex() < 0) {
                        Classifier.this.stop();
                        String errorMessage = String.valueOf(Classifier.this.statusMessagePrefix()) + "ERROR: no class attribute set in test data!";
                        if (Classifier.this.m_log != null) {
                            Classifier.this.m_log.statusMessage(errorMessage);
                            Classifier.this.m_log.logMessage("[Classifier] " + errorMessage);
                        } else {
                            System.err.println("[Classifier] " + errorMessage);
                        }
                        return;
                    }
                    try {
                        if (this.m_runNum == 1 && this.m_setNum == 1) {
                            Classifier.this.m_state = BUILDING_MODEL;
                            this.m_taskInfo.setExecutionStatus(1);
                        }
                        String msg = String.valueOf(Classifier.this.statusMessagePrefix()) + "Building model for run " + this.m_runNum + " fold " + this.m_setNum;
                        if (Classifier.this.m_log != null) {
                            Classifier.this.m_log.statusMessage(msg);
                        } else {
                            System.err.println(msg);
                        }
                        weka.classifiers.Classifier classifierCopy = AbstractClassifier.makeCopy(Classifier.this.m_ClassifierTemplate);
                        if (classifierCopy instanceof EnvironmentHandler && Classifier.this.m_env != null) {
                            ((EnvironmentHandler)((Object)classifierCopy)).setEnvironment(Classifier.this.m_env);
                        }
                        classifierCopy.buildClassifier(this.m_train);
                        if (this.m_runNum == this.m_maxRunNum && this.m_setNum == this.m_maxSetNum) {
                            Classifier.this.m_Classifier = classifierCopy;
                            Classifier.this.m_trainingSet = new Instances(this.m_train, 0);
                        }
                        BatchClassifierEvent ce = new BatchClassifierEvent(Classifier.this, classifierCopy, new DataSetEvent(this, this.m_train), null, this.m_setNum, this.m_maxSetNum);
                        ce.setGroupIdentifier(Classifier.this.m_currentBatchIdentifier.getTime());
                        ce.setLabel(Classifier.this.getCustomName());
                        Classifier.this.notifyBatchClassifierListeners(ce);
                        ce = new BatchClassifierEvent(Classifier.this, classifierCopy, new DataSetEvent(this, this.m_train), null, this.m_setNum, this.m_maxSetNum);
                        ce.setGroupIdentifier(Classifier.this.m_currentBatchIdentifier.getTime());
                        ce.setLabel(Classifier.this.getCustomName());
                        Classifier.this.classifierTrainingComplete(ce);
                        if (classifierCopy instanceof Drawable && Classifier.this.m_graphListeners.size() > 0) {
                            String grphString = ((Drawable)((Object)classifierCopy)).graph();
                            int grphType = ((Drawable)((Object)classifierCopy)).graphType();
                            String grphTitle = classifierCopy.getClass().getName();
                            grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
                            grphTitle = "Set " + this.m_setNum + " (" + this.m_train.relationName() + ") " + grphTitle;
                            GraphEvent ge = new GraphEvent(Classifier.this, grphString, grphTitle, grphType);
                            Classifier.this.notifyGraphListeners(ge);
                        }
                        if (Classifier.this.m_textListeners.size() > 0) {
                            String modelString = classifierCopy.toString();
                            String titleString = classifierCopy.getClass().getName();
                            titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                            modelString = "=== Classifier model ===\n\nScheme:   " + titleString + "\n" + "Relation: " + this.m_train.relationName() + (this.m_maxSetNum > 1 ? "\nTraining Fold: " + this.m_setNum : "") + "\n\n" + modelString;
                            titleString = "Model: " + titleString;
                            TextEvent nt = new TextEvent(Classifier.this, modelString, titleString);
                            Classifier.this.notifyTextListeners(nt);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (Classifier.this.m_log != null) {
                            String titleString = "[Classifier] " + Classifier.this.statusMessagePrefix();
                            titleString = String.valueOf(titleString) + " run " + this.m_runNum + " fold " + this.m_setNum + " failed to complete.";
                            Classifier.this.m_log.logMessage(String.valueOf(titleString) + " (build classifier). " + ex.getMessage());
                            Classifier.this.m_log.statusMessage(String.valueOf(Classifier.this.statusMessagePrefix()) + "ERROR (see log for details)");
                            ex.printStackTrace();
                        }
                        this.m_taskInfo.setExecutionStatus(2);
                        Classifier.this.stop();
                    }
                }
                finally {
                    Classifier.this.m_visual.setStatic();
                    if (Classifier.this.m_log != null && this.m_setNum == this.m_maxSetNum) {
                        Classifier.this.m_log.statusMessage(String.valueOf(Classifier.this.statusMessagePrefix()) + "Finished.");
                    }
                    Classifier.this.m_state = IDLE;
                    if (Thread.currentThread().isInterrupted()) {
                        Classifier.this.m_trainingSet = null;
                        if (Classifier.this.m_log != null) {
                            String titleString = "[Classifier] " + Classifier.this.statusMessagePrefix();
                            Classifier.this.m_log.logMessage(String.valueOf(titleString) + " (" + " run " + this.m_runNum + " fold " + this.m_setNum + ") interrupted!");
                            Classifier.this.m_log.statusMessage(String.valueOf(Classifier.this.statusMessagePrefix()) + "INTERRUPTED");
                        }
                    }
                }
            }
        }

        @Override
        public TaskStatusInfo getTaskStatus() {
            return null;
        }
    }
}

