/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.FirstKInitialMeans"})
public class FirstKInitialMeans<O>
implements KMeansInitialization<NumberVector>,
KMedoidsInitialization<O> {
    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        DBIDIter dBIDIter = relation.iterDBIDs();
        ArrayList<V> arrayList = new ArrayList<V>(n);
        for (int i = 0; i < n && dBIDIter.valid(); ++i) {
            arrayList.add(factory.newNumberVector((NumberVector)relation.get(dBIDIter)));
            dBIDIter.advance();
        }
        return arrayList;
    }

    @Override
    public DBIDs chooseInitialMedoids(int n, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery) {
        DBIDIter dBIDIter = dBIDs.iter();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        for (int i = 0; i < n && dBIDIter.valid(); ++i) {
            arrayModifiableDBIDs.add(dBIDIter);
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        @Override
        protected FirstKInitialMeans<V> makeInstance() {
            return new FirstKInitialMeans();
        }
    }
}

