/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.BufferedLineReader;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalDoubleOutlierScore
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ExternalDoubleOutlierScore.class);
    public static final String COMMENT = "#";
    public static final String ID_PATTERN_DEFAULT = "^ID=";
    private File file;
    private Pattern idpattern;
    private Pattern scorepattern;
    private ScalingFunction scaling;
    private boolean inverted = false;

    public ExternalDoubleOutlierScore(File file, Pattern pattern, Pattern pattern2, boolean bl, ScalingFunction scalingFunction) {
        this.file = file;
        this.idpattern = pattern;
        this.scorepattern = pattern2;
        this.inverted = bl;
        this.scaling = scalingFunction;
    }

    public OutlierResult run(Database database, Relation<?> relation) {
        Iter iter;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        try {
            object4 = FileUtil.tryGzipInput(new FileInputStream(this.file));
            object3 = null;
            try {
                object2 = CSVReaderFormat.DEFAULT_FORMAT.makeReader();
                object = null;
                try {
                    iter = ((TokenizedReader)object2).getTokenizer();
                    CharSequence charSequence = ((BufferedLineReader)object2).getBuffer();
                    Matcher matcher = this.idpattern.matcher(charSequence);
                    Matcher matcher2 = this.scorepattern.matcher(charSequence);
                    ((BufferedLineReader)object2).reset((InputStream)object4);
                    while (((TokenizedReader)object2).nextLineExceptComments()) {
                        Integer n = null;
                        double d = Double.NaN;
                        while (((Tokenizer)iter).valid()) {
                            matcher.region(((Tokenizer)iter).getStart(), ((Tokenizer)iter).getEnd());
                            matcher2.region(((Tokenizer)iter).getStart(), ((Tokenizer)iter).getEnd());
                            boolean bl = matcher.find();
                            boolean bl2 = matcher2.find();
                            if (bl && bl2) {
                                throw new AbortException("ID pattern and score pattern both match value: " + ((Tokenizer)iter).getSubstring());
                            }
                            if (bl) {
                                if (n != null) {
                                    throw new AbortException("ID pattern matched twice: previous value " + n + " second value: " + ((Tokenizer)iter).getSubstring());
                                }
                                n = Integer.parseInt(charSequence.subSequence(matcher.end(), ((Tokenizer)iter).getEnd()).toString());
                            }
                            if (bl2) {
                                if (!Double.isNaN(d)) {
                                    throw new AbortException("Score pattern matched twice: previous value " + d + " second value: " + ((Tokenizer)iter).getSubstring());
                                }
                                d = FormatUtil.parseDouble(charSequence.subSequence(matcher2.end(), ((Tokenizer)iter).getEnd()).toString());
                            }
                            ((Tokenizer)iter).advance();
                        }
                        if (n != null && !Double.isNaN(d)) {
                            writableDoubleDataStore.putDouble(DBIDUtil.importInteger(n), d);
                            doubleMinMax.put(d);
                            continue;
                        }
                        if (n == null && Double.isNaN(d)) {
                            LOG.warning("Line did not match either ID nor score nor comment: " + ((BufferedLineReader)object2).getLineNumber());
                            continue;
                        }
                        throw new AbortException("Line matched only ID or only SCORE patterns: " + ((BufferedLineReader)object2).getLineNumber());
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((TokenizedReader)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((TokenizedReader)object2).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            ((InputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object4).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new AbortException("Could not load outlier scores: " + iOException.getMessage() + " when loading " + this.file, iOException);
        }
        object4 = this.inverted ? new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax()) : new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        object3 = new MaterializedDoubleRelation("External Outlier", "external-outlier", writableDoubleDataStore, relation.getDBIDs());
        object2 = new OutlierResult((OutlierScoreMeta)object4, (DoubleRelation)object3);
        if (this.scaling instanceof OutlierScalingFunction) {
            ((OutlierScalingFunction)this.scaling).prepare((OutlierResult)object2);
        }
        object = new DoubleMinMax();
        iter = relation.iterDBIDs();
        while (iter.valid()) {
            double d = object3.doubleValue((DBIDRef)((Object)iter));
            d = this.scaling.getScaled(d);
            writableDoubleDataStore.putDouble((DBIDRef)((Object)iter), d);
            ((DoubleMinMax)object).put(d);
            iter.advance();
        }
        object4 = new BasicOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax());
        object2 = new OutlierResult((OutlierScoreMeta)object4, (DoubleRelation)object3);
        return object2;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILE_ID = new OptionID("externaloutlier.file", "The file name containing the (external) outlier scores.");
        public static final OptionID ID_ID = new OptionID("externaloutlier.idpattern", "The pattern to match object ID prefix");
        public static final OptionID SCORE_ID = new OptionID("externaloutlier.scorepattern", "The pattern to match object score prefix");
        public static final OptionID SCALING_ID = new OptionID("externaloutlier.scaling", "Class to use as scaling function.");
        public static final OptionID INVERTED_ID = new OptionID("externaloutlier.inverted", "Flag to signal an inverted outlier score.");
        private File file;
        private Pattern idpattern;
        private Pattern scorepattern;
        private ScalingFunction scaling;
        private boolean inverted = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            Flag flag;
            PatternParameter patternParameter;
            PatternParameter patternParameter2;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.file = (File)fileParameter.getValue();
            }
            if (parameterization.grab(patternParameter2 = new PatternParameter(ID_ID, ExternalDoubleOutlierScore.ID_PATTERN_DEFAULT))) {
                this.idpattern = (Pattern)patternParameter2.getValue();
            }
            if (parameterization.grab(patternParameter = new PatternParameter(SCORE_ID))) {
                this.scorepattern = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(INVERTED_ID))) {
                this.inverted = (Boolean)flag.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ExternalDoubleOutlierScore makeInstance() {
            return new ExternalDoubleOutlierScore(this.file, this.idpattern, this.scorepattern, this.inverted, this.scaling);
        }
    }
}

