/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SimpleOutlierEnsemble
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleOutlierEnsemble.class);
    private List<OutlierAlgorithm> algorithms;
    private EnsembleVoting voting;

    public SimpleOutlierEnsemble(List<OutlierAlgorithm> list, EnsembleVoting ensembleVoting) {
        this.algorithms = list;
        this.voting = ensembleVoting;
    }

    @Override
    public OutlierResult run(Database database) throws IllegalStateException {
        Object object;
        Object object2;
        int n = this.algorithms.size();
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        ArrayList<OutlierResult> arrayList = new ArrayList<OutlierResult>(n);
        Object object4 = LOG.isVerbose() ? new FiniteProgress("Inner outlier algorithms", n, LOG) : null;
        for (Algorithm object32 : this.algorithms) {
            object2 = object32.run(database);
            object = ResultUtil.getOutlierResults((Result)object2);
            Iterator<OutlierResult> iterator = object.iterator();
            while (iterator.hasNext()) {
                OutlierResult d = iterator.next();
                arrayList.add(d);
                hashSetModifiableDBIDs.addDBIDs(d.getScores().getDBIDs());
            }
            LOG.incrementProcessed((AbstractProgress)object4);
        }
        LOG.ensureCompleted((FiniteProgress)object4);
        object4 = DataStoreUtil.makeDoubleStorage(hashSetModifiableDBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Combining results", hashSetModifiableDBIDs.size(), LOG) : null;
        object2 = hashSetModifiableDBIDs.iter();
        while (object2.valid()) {
            object = new double[n];
            int n2 = 0;
            for (OutlierResult outlierResult : arrayList) {
                double d = outlierResult.getScores().doubleValue((DBIDRef)object2);
                if (!Double.isNaN(d)) {
                    object[n2] = d;
                    ++n2;
                    continue;
                }
                LOG.warning("DBID " + object2 + " was not given a score by result " + outlierResult);
            }
            if (n2 > 0) {
                if (n2 < ((Object)object).length) {
                    object = Arrays.copyOf((double[])object, n2);
                }
                double d = this.voting.combine((double[])object);
                object4.putDouble((DBIDRef)object2, d);
                doubleMinMax.put(d);
            } else {
                LOG.warning("DBID " + object2 + " was not given any score at all.");
            }
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        object2 = new MaterializedDoubleRelation("Simple Outlier Ensemble", "ensemble-outlier", (DoubleDataStore)object4, hashSetModifiableDBIDs);
        return new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] typeInformationArray = new TypeInformation[this.algorithms.size()];
        for (int i = 0; i < typeInformationArray.length; ++i) {
            typeInformationArray[i] = this.algorithms.get(i).getInputTypeRestriction()[0];
        }
        return TypeUtil.array(new CombinedTypeInformation(typeInformationArray));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID VOTING_ID = new OptionID("ensemble.voting", "Voting strategy to use in the ensemble.");
        private List<OutlierAlgorithm> algorithms;
        private EnsembleVoting voting;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Object object;
            super.makeOptions(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, OutlierAlgorithm.class);
            if (parameterization.grab(objectListParameter)) {
                object = new ListParameterization();
                ChainedParameterization chainedParameterization = new ChainedParameterization(new Parameterization[]{object, parameterization});
                chainedParameterization.errorsTo(parameterization);
                this.algorithms = objectListParameter.instantiateClasses(chainedParameterization);
                ((AbstractParameterization)object).logAndClearReportedErrors();
            }
            if (parameterization.grab((Parameter<?>)(object = new ObjectParameter(VOTING_ID, EnsembleVoting.class)))) {
                this.voting = (EnsembleVoting)((ObjectParameter)object).instantiateClass(parameterization);
            }
        }

        @Override
        protected SimpleOutlierEnsemble makeInstance() {
            return new SimpleOutlierEnsemble(this.algorithms, this.voting);
        }
    }
}

