/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.covertree;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractCoverTree<O>
extends AbstractIndex<O> {
    final double expansion;
    final double invLogExpansion;
    protected final int scaleBottom;
    protected DistanceFunction<? super O> distanceFunction;
    private DistanceQuery<O> distanceQuery;
    protected long distComputations = 0L;
    protected int truncate = 10;

    public AbstractCoverTree(Relation<O> relation, DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(relation);
        this.distanceFunction = distanceFunction;
        this.distanceQuery = distanceFunction.instantiate(relation);
        this.truncate = n;
        this.expansion = d;
        this.invLogExpansion = 1.0 / Math.log(d);
        this.scaleBottom = (int)Math.ceil(Math.log(Double.MIN_NORMAL) * this.invLogExpansion);
    }

    protected final double scaleToDist(int n) {
        return Math.pow(this.expansion, n);
    }

    protected final int distToScale(double d) {
        return (int)Math.ceil(Math.log(d) * this.invLogExpansion);
    }

    protected double maxDistance(DoubleDBIDList doubleDBIDList) {
        double d = 0.0;
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            double d2 = doubleDBIDListIter.doubleValue();
            d = d > d2 ? d : d2;
            doubleDBIDListIter.advance();
        }
        return d;
    }

    protected double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        ++this.distComputations;
        return this.distanceQuery.distance(dBIDRef, dBIDRef2);
    }

    protected double distance(O o, DBIDRef dBIDRef) {
        ++this.distComputations;
        return this.distanceQuery.distance((DBIDRef)o, dBIDRef);
    }

    protected void excludeNotCovered(ModifiableDoubleDBIDList modifiableDoubleDBIDList, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList2) {
        DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
        while (doubleDBIDListMIter.valid()) {
            if (doubleDBIDListMIter.doubleValue() > d) {
                modifiableDoubleDBIDList2.add(doubleDBIDListMIter.doubleValue(), doubleDBIDListMIter);
                modifiableDoubleDBIDList.removeSwap(doubleDBIDListMIter.getOffset());
                continue;
            }
            doubleDBIDListMIter.advance();
        }
    }

    protected void collectByCover(DBIDRef dBIDRef, ModifiableDoubleDBIDList modifiableDoubleDBIDList, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList2) {
        assert (modifiableDoubleDBIDList2.size() == 0) : "Not empty";
        DoubleDBIDListIter doubleDBIDListIter = modifiableDoubleDBIDList.iter().advance();
        while (doubleDBIDListIter.valid()) {
            assert (!DBIDUtil.equal(dBIDRef, doubleDBIDListIter));
            double d2 = this.distance(dBIDRef, (DBIDRef)doubleDBIDListIter);
            if (d2 <= d) {
                modifiableDoubleDBIDList2.add(d2, doubleDBIDListIter);
                modifiableDoubleDBIDList.removeSwap(doubleDBIDListIter.getOffset());
                continue;
            }
            doubleDBIDListIter.advance();
        }
    }

    @Override
    public void logStatistics() {
        this.getLogger().statistics(new LongStatistic(this.getClass().getName() + ".distance-computations", this.distComputations));
    }

    protected abstract Logging getLogger();

    @Override
    public String getLongName() {
        return "Cover Tree";
    }

    @Override
    public String getShortName() {
        return "cover-tree";
    }

    public static abstract class Factory<O, I extends AbstractCoverTree<O>>
    implements IndexFactory<O, I> {
        protected DistanceFunction<? super O> distanceFunction;
        protected double expansion;
        protected int truncate;

        public Factory(DistanceFunction<? super O> distanceFunction, double d, int n) {
            this.distanceFunction = distanceFunction;
            this.expansion = d;
            this.truncate = n;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static abstract class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("covertree.distancefunction", "Distance function to determine the distance between objects.");
            public static final OptionID TRUNCATE_ID = new OptionID("covertree.truncate", "Truncate tree when branches have less than this number of instances.");
            public static final OptionID EXPANSION_ID = new OptionID("covertree.expansionrate", "Expansion rate of the tree (Default: 1.3).");
            protected DistanceFunction<? super O> distanceFunction;
            protected int truncate = 10;
            protected double expansion = 1.3;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                DoubleParameter doubleParameter;
                IntParameter intParameter;
                super.makeOptions(parameterization);
                ObjectParameter objectParameter = new ObjectParameter(DISTANCE_FUNCTION_ID, DistanceFunction.class);
                if (parameterization.grab(objectParameter)) {
                    this.distanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
                    if (!this.distanceFunction.isMetric()) {
                        LoggingUtil.warning("CoverTree requires a metric to be exact.");
                    }
                }
                if (parameterization.grab(intParameter = (IntParameter)new IntParameter(TRUNCATE_ID, 10).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.truncate = intParameter.intValue();
                }
                if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(EXPANSION_ID, 1.3).addConstraint(CommonConstraints.GREATER_THAN_ONE_DOUBLE))) {
                    this.expansion = doubleParameter.doubleValue();
                }
            }
        }
    }
}

