/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class GeneralizedLogisticDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape;

    public GeneralizedLogisticDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    public GeneralizedLogisticDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.location = d;
        this.scale = d2;
        this.shape = d3;
    }

    public GeneralizedLogisticDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.location = d;
        this.scale = d2;
        this.shape = d3;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        double d5 = Math.exp(-d);
        double d6 = 1.0 + d5;
        return d4 * d5 / (d3 * Math.pow(d6, d4 + 1.0));
    }

    public static double logpdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        double d5 = Math.exp(-d);
        return -(d + (d4 + 1.0) * Math.log1p(d5)) + Math.log(d4);
    }

    @Override
    public double pdf(double d) {
        return GeneralizedLogisticDistribution.pdf(d, this.location, this.scale, this.shape);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        return Math.pow(1.0 + Math.exp(-d), -d4);
    }

    public static double logcdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        return Math.log1p(Math.exp(-d)) * -d4;
    }

    @Override
    public double cdf(double d) {
        return GeneralizedLogisticDistribution.cdf(d, this.location, this.scale, this.shape);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        return d2 + d3 * -Math.log(Math.pow(d, -1.0 / d4) - 1.0);
    }

    @Override
    public double quantile(double d) {
        return GeneralizedLogisticDistribution.quantile(d, this.location, this.scale, this.shape);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        return this.location + this.scale * -Math.log(Math.pow(d, -1.0 / this.shape) - 1.0);
    }

    @Override
    public String toString() {
        return "GeneralizedLogisticDistribution(location=" + this.location + ", scale=" + this.scale + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double location;
        double scale;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.location = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.scale = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GeneralizedLogisticDistribution makeInstance() {
            return new GeneralizedLogisticDistribution(this.location, this.scale, this.shape, this.rnd);
        }
    }
}

