/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Random;

public class PoissonDistribution
extends AbstractDistribution {
    private int n;
    private double p;
    private static final double S0 = 0.08333333333333333;
    private static final double S1 = 0.002777777777777778;
    private static final double S2 = 7.936507936507937E-4;
    private static final double S3 = 5.952380952380953E-4;
    private static final double S4 = 8.417508417508417E-4;
    private static final double[] STIRLING_EXACT_ERROR = new double[]{0.0, 0.15342640972002736, 0.08106146679532726, 0.05481412105191765, 0.0413406959554093, 0.03316287351993629, 0.02767792568499834, 0.023746163656297496, 0.020790672103765093, 0.018488450532673187, 0.016644691189821193, 0.015134973221917378, 0.013876128823070748, 0.012810465242920227, 0.01189670994589177, 0.011104559758206917, 0.010411265261972096, 0.009799416126158804, 0.009255462182712733, 0.008768700134139386, 0.00833056343336287, 0.00793411456431402, 0.007573675487951841, 0.007244554301320383, 0.00694284010720953, 0.006665247032707682, 0.006408994188004207, 0.006171712263039458, 0.0059513701127588475, 0.0057462165130101155, 0.005554733551962801};

    public PoissonDistribution(int n, double d) {
        this(n, d, (Random)null);
    }

    public PoissonDistribution(int n, double d, Random random) {
        super(random);
        this.n = n;
        this.p = d;
    }

    public PoissonDistribution(int n, double d, RandomFactory randomFactory) {
        super(randomFactory);
        this.n = n;
        this.p = d;
    }

    public double pmf(int n) {
        return PoissonDistribution.pmf(n, this.n, this.p);
    }

    @Override
    public double pdf(double d) {
        return PoissonDistribution.pmf(d, this.n, this.p);
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf")
    public static double pmf(double d, int n, double d2) {
        if (d < 0.0 || d > (double)n) {
            return 0.0;
        }
        if (d2 <= 0.0) {
            return d == 0.0 ? 1.0 : 0.0;
        }
        if (d2 >= 1.0) {
            return d == (double)n ? 1.0 : 0.0;
        }
        double d3 = 1.0 - d2;
        if (d == 0.0) {
            if (d2 < 0.1) {
                return Math.exp(-PoissonDistribution.devianceTerm(n, (double)n * d3) - (double)n * d2);
            }
            return Math.exp((double)n * Math.log(d3));
        }
        if (d == (double)n) {
            if (d2 > 0.9) {
                return Math.exp(-PoissonDistribution.devianceTerm(n, (double)n * d2) - (double)n * d3);
            }
            return Math.exp((double)n * Math.log(d2));
        }
        double d4 = PoissonDistribution.stirlingError(n) - PoissonDistribution.stirlingError(d) - PoissonDistribution.stirlingError((double)n - d) - PoissonDistribution.devianceTerm(d, (double)n * d2) - PoissonDistribution.devianceTerm((double)n - d, (double)n * d3);
        double d5 = Math.PI * 2 * d * ((double)n - d) / (double)n;
        return Math.exp(d4) / Math.sqrt(d5);
    }

    @Override
    public double cdf(double d) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public double quantile(double d) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public double nextRandom() {
        throw new NotImplementedException("Not yet supported.");
    }

    public static double poissonPDFm1(double d, double d2) {
        if (Double.isInfinite(d2)) {
            return 0.0;
        }
        if (d > 1.0) {
            return PoissonDistribution.rawProbability(d - 1.0, d2);
        }
        if (d2 > Math.abs(d - 1.0) * MathUtil.LOG2 * 1023.0 / 1.0E-14) {
            return Math.exp(-d2 - GammaDistribution.logGamma(d));
        }
        return PoissonDistribution.rawProbability(d, d2) * (d / d2);
    }

    public static double logpoissonPDFm1(double d, double d2) {
        if (Double.isInfinite(d2)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d > 1.0) {
            return PoissonDistribution.rawLogProbability(d - 1.0, d2);
        }
        if (d2 > Math.abs(d - 1.0) * MathUtil.LOG2 * 1023.0 / 1.0E-14) {
            return -d2 - GammaDistribution.logGamma(d);
        }
        return PoissonDistribution.rawLogProbability(d, d2) + Math.log(d / d2);
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf")
    private static double stirlingError(int n) {
        if (n < 16) {
            return STIRLING_EXACT_ERROR[n << 1];
        }
        double d = n * n;
        if (n > 500) {
            return (0.08333333333333333 - 0.002777777777777778 / d) / (double)n;
        }
        if (n > 80) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / d)) / d / (double)n;
        }
        if (n > 35) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / d) / d) / d) / (double)n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / d) / d) / d) / d) / (double)n;
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf")
    private static double stirlingError(double d) {
        if (d < 16.0) {
            double d2 = 2.0 * d;
            if (Math.floor(d2) == d2) {
                return STIRLING_EXACT_ERROR[(int)d2];
            }
            return GammaDistribution.logGamma(d + 1.0) - (d + 0.5) * Math.log(d) + d - MathUtil.LOGSQRTTWOPI;
        }
        double d3 = d * d;
        if (d > 500.0) {
            return (0.08333333333333333 - 0.002777777777777778 / d3) / d;
        }
        if (d > 80.0) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / d3)) / d3 / d;
        }
        if (d > 35.0) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / d3) / d3) / d3) / d;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / d3) / d3) / d3) / d3) / d;
    }

    @Reference(title="Fast and accurate computation of binomial probabilities", authors="C. Loader", booktitle="", url="http://projects.scipy.org/scipy/raw-attachment/ticket/620/loader2000Fast.pdf")
    private static double devianceTerm(double d, double d2) {
        if (Math.abs(d - d2) < 0.1 * (d + d2)) {
            double d3 = (d - d2) / (d + d2);
            double d4 = (d - d2) * d3;
            double d5 = 2.0 * d * d3;
            int n = 1;
            while (true) {
                double d6;
                if ((d6 = d4 + (d5 *= d3 * d3) / (double)(2 * n + 1)) == d4) {
                    return d6;
                }
                d4 = d6;
                ++n;
            }
        }
        return d * Math.log(d / d2) + d2 - d;
    }

    public static double rawProbability(double d, double d2) {
        if (d2 == 0.0) {
            return d == 0.0 ? 1.0 : 0.0;
        }
        if (Double.isInfinite(d2) || d < 0.0) {
            return 0.0;
        }
        if (d <= d2 * Double.MIN_NORMAL) {
            return Math.exp(-d2);
        }
        if (d2 < d * Double.MIN_NORMAL) {
            double d3 = -d2 + d * Math.log(d2) - GammaDistribution.logGamma(d + 1.0);
            return Math.exp(d3);
        }
        double d4 = Math.PI * 2 * d;
        double d5 = -PoissonDistribution.stirlingError(d) - PoissonDistribution.devianceTerm(d, d2);
        return Math.exp(d5) / Math.sqrt(d4);
    }

    public static double rawLogProbability(double d, double d2) {
        if (d2 == 0.0) {
            return d == 0.0 ? 1.0 : Double.NEGATIVE_INFINITY;
        }
        if (Double.isInfinite(d2) || d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d <= d2 * Double.MIN_NORMAL) {
            return -d2;
        }
        if (d2 < d * Double.MIN_NORMAL) {
            return -d2 + d * Math.log(d2) - GammaDistribution.logGamma(d + 1.0);
        }
        double d3 = Math.PI * 2 * d;
        double d4 = -PoissonDistribution.stirlingError(d) - PoissonDistribution.devianceTerm(d, d2);
        return -0.5 * Math.log(d3) + d4;
    }

    @Override
    public String toString() {
        return "PoissonDistribution(n=" + this.n + ", p=" + this.p + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID N_ID = new OptionID("distribution.poisson.n", "Number of trials.");
        public static final OptionID PROB_ID = new OptionID("distribution.poisson.probability", "Success probability.");
        int n;
        double p;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(N_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.n = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(PROB_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.p = doubleParameter.doubleValue();
            }
        }

        @Override
        protected PoissonDistribution makeInstance() {
            return new PoissonDistribution(this.n, this.p, this.rnd);
        }
    }
}

