/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class RayleighMLEEstimator
implements DistributionEstimator<RayleighDistribution> {
    public static final RayleighMLEEstimator STATIC = new RayleighMLEEstimator();

    private RayleighMLEEstimator() {
    }

    @Override
    public <A> RayleighDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i);
            d += d2 * d2;
        }
        return new RayleighDistribution(Math.sqrt(0.5 * d / (double)n));
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighMLEEstimator makeInstance() {
            return STATIC;
        }
    }
}

