/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L. Amsaleg and O. Chelly and T. Furon and S. Girard and M. E. Houle and K. Kawarabayashi and M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="http://dx.doi.org/10.1145/2783258.2783405")
public class MOMEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final MOMEstimator STATIC = new MOMEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double d = 0.0;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            d += numberArrayAdapter.getDouble(a, i);
        }
        return (d /= (double)n2 * numberArrayAdapter.getDouble(a, n2)) / (1.0 - d);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

