/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import de.lmu.ifi.dbs.elki.utilities.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BufferedLineReader
implements AutoCloseable {
    private LineReader reader = null;
    protected StringBuilder buf = new StringBuilder(1024);
    protected int lineNumber = 0;

    public BufferedLineReader() {
        this.reader = null;
    }

    public BufferedLineReader(LineReader lineReader) {
        this.reader = lineReader;
    }

    public BufferedLineReader(InputStream inputStream) {
        this(new LineReader(new InputStreamReader(inputStream)));
    }

    public BufferedLineReader(InputStreamReader inputStreamReader) {
        this(new LineReader(inputStreamReader));
    }

    public void reset() {
        this.reader = null;
        this.buf.setLength(0);
        this.lineNumber = 0;
    }

    public void reset(LineReader lineReader) {
        this.reset();
        this.reader = lineReader;
    }

    public void reset(InputStream inputStream) {
        this.reset();
        this.reader = new LineReader(inputStream);
    }

    public void reset(InputStreamReader inputStreamReader) {
        this.reset();
        this.reader = new LineReader(inputStreamReader);
    }

    public CharSequence getBuffer() {
        return this.buf;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean nextLine() throws IOException {
        while (this.reader.readLine(this.buf.delete(0, this.buf.length()))) {
            ++this.lineNumber;
            if (BufferedLineReader.lengthWithoutLinefeed(this.buf) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.buf.setLength(0);
        this.buf.trimToSize();
    }

    public static int lengthWithoutLinefeed(CharSequence charSequence) {
        char c;
        int n;
        for (n = charSequence.length(); n > 0 && ((c = charSequence.charAt(n - 1)) == '\n' || c == '\r'); --n) {
        }
        return n;
    }
}

