/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OnlyOneIsAllowedToBeSetGlobalConstraint
implements GlobalParameterConstraint {
    private List<Parameter<?>> parameters;

    public OnlyOneIsAllowedToBeSetGlobalConstraint(List<Parameter<?>> list) {
        this.parameters = list;
    }

    public OnlyOneIsAllowedToBeSetGlobalConstraint(Parameter<?> ... parameterArray) {
        this.parameters = Arrays.asList(parameterArray);
    }

    @Override
    public void test() throws ParameterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter<?> parameter : this.parameters) {
            if (!parameter.isDefined()) continue;
            if (parameter instanceof Flag) {
                if (!((Boolean)((Flag)parameter).getValue()).booleanValue()) continue;
                arrayList.add(parameter.getName());
                continue;
            }
            arrayList.add(parameter.getName());
        }
        if (arrayList.size() > 1) {
            throw new WrongParameterValueException("Global Parameter Constraint Error.\nOnly one of the parameters " + OptionUtil.optionsNamesToString(this.parameters) + " is allowed to be set. " + "Parameters currently set: " + arrayList.toString());
        }
    }

    @Override
    public String getDescription() {
        return "Only one of the parameters " + OptionUtil.optionsNamesToString(this.parameters) + " is allowed to be set.";
    }
}

