/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel.KMeansProcessor;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;
import java.util.List;

public class ParallelLloydKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(ParallelLloydKMeans.class);

    public ParallelLloydKMeans(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        KMeansProcessor<V> kMeansProcessor = new KMeansProcessor<V>(relation, this.distanceFunction, writableIntegerDataStore, dArray);
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        for (int i = 0; this.maxiter <= 0 || i < this.maxiter; ++i) {
            LOG.incrementProcessed(indefiniteProgress);
            kMeansProcessor.nextIteration(list);
            ParallelExecutor.run(dBIDs, kMeansProcessor);
            if (!kMeansProcessor.changed()) break;
            list = kMeansProcessor.getMeans();
        }
        LOG.setCompleted(indefiniteProgress);
        ArrayModifiableDBIDs[] arrayModifiableDBIDsArray = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(dBIDs, writableIntegerDataStore, this.k);
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < arrayModifiableDBIDsArray.length; ++i) {
            ArrayModifiableDBIDs arrayModifiableDBIDs = arrayModifiableDBIDsArray[i];
            if (arrayModifiableDBIDs.size() == 0) continue;
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>((DBIDs)arrayModifiableDBIDs, kMeansModel));
        }
        return clustering;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected ParallelLloydKMeans<V> makeInstance() {
            return new ParallelLloydKMeans(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

