/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEInterval;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUESubspace;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEUnit;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

@Title(value="CLIQUE: Automatic Subspace Clustering of High Dimensional Data for Data Mining Applications")
@Description(value="Grid-based algorithm to identify dense clusters in subspaces of maximum dimensionality.")
@Reference(authors="R. Agrawal, J. Gehrke, D. Gunopulos, P. Raghavan", title="Automatic Subspace Clustering of High Dimensional Data for Data Mining Applications", booktitle="Proc. SIGMOD Conference, Seattle, WA, 1998", url="http://dx.doi.org/10.1145/276304.276314")
public class CLIQUE<V extends NumberVector>
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(CLIQUE.class);
    public static final OptionID XSI_ID = new OptionID("clique.xsi", "The number of intervals (units) in each dimension.");
    public static final OptionID TAU_ID = new OptionID("clique.tau", "The density threshold for the selectivity of a unit, where the selectivity isthe fraction of total feature vectors contained in this unit.");
    public static final OptionID PRUNE_ID = new OptionID("clique.prune", "Flag to indicate that only subspaces with large coverage (i.e. the fraction of the database that is covered by the dense units) are selected, the rest will be pruned.");
    private int xsi;
    private double tau;
    private boolean prune;

    public CLIQUE(int n, double d, boolean bl) {
        this.xsi = n;
        this.tau = d;
        this.prune = bl;
    }

    public Clustering<SubspaceModel> run(Relation<V> relation) {
        int n;
        if (LOG.isVerbose()) {
            LOG.verbose("*** 1. Identification of subspaces that contain clusters ***");
        }
        TreeMap<Integer, List<CLIQUESubspace<V>>> treeMap = new TreeMap<Integer, List<CLIQUESubspace<V>>>();
        List<CLIQUESubspace<V>> list = this.findOneDimensionalDenseSubspaces(relation);
        treeMap.put(0, list);
        if (LOG.isVerbose()) {
            LOG.verbose("    1-dimensional dense subspaces: " + list.size());
        }
        if (LOG.isDebugging()) {
            for (CLIQUESubspace<V> cLIQUESubspace : list) {
                LOG.debug(cLIQUESubspace.toString("      "));
            }
        }
        int n2 = RelationUtil.dimensionality(relation);
        for (n = 2; n <= n2 && !list.isEmpty(); ++n) {
            list = this.findDenseSubspaces(relation, list);
            treeMap.put(n - 1, list);
            if (LOG.isVerbose()) {
                LOG.verbose("    " + n + "-dimensional dense subspaces: " + list.size());
            }
            if (!LOG.isDebugging()) continue;
            for (CLIQUESubspace object : list) {
                LOG.debug(object.toString("      "));
            }
        }
        if (LOG.isVerbose()) {
            LOG.verbose("*** 2. Identification of clusters ***");
        }
        n = 1;
        Clustering<SubspaceModel> clustering = new Clustering<SubspaceModel>("CLIQUE clustering", "clique-clustering");
        for (Integer n3 : treeMap.keySet()) {
            List list2 = (List)treeMap.get(n3);
            List<Pair<Subspace, ModifiableDBIDs>> list3 = this.determineClusters(list2);
            if (LOG.isVerbose()) {
                LOG.verbose("    " + (n3 + 1) + "-dimensional clusters: " + list3.size());
            }
            for (Pair<Subspace, ModifiableDBIDs> pair : list3) {
                Cluster<SubspaceModel> cluster = new Cluster<SubspaceModel>((DBIDs)pair.second);
                cluster.setModel(new SubspaceModel((Subspace)pair.first, Centroid.make(relation, (DBIDs)pair.second)));
                cluster.setName("cluster_" + n++);
                clustering.addToplevelCluster(cluster);
            }
        }
        return clustering;
    }

    private List<Pair<Subspace, ModifiableDBIDs>> determineClusters(List<CLIQUESubspace<V>> list) {
        ArrayList<Pair<Subspace, ModifiableDBIDs>> arrayList = new ArrayList<Pair<Subspace, ModifiableDBIDs>>();
        for (CLIQUESubspace<V> cLIQUESubspace : list) {
            List<Pair<Subspace, ModifiableDBIDs>> list2 = cLIQUESubspace.determineClusters();
            if (LOG.isDebugging()) {
                LOG.debugFine("Subspace " + cLIQUESubspace + " clusters " + list2.size());
            }
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private List<CLIQUESubspace<V>> findOneDimensionalDenseSubspaces(Relation<V> relation) {
        List<CLIQUESubspace<V>> list = this.findOneDimensionalDenseSubspaceCandidates(relation);
        if (this.prune) {
            return this.pruneDenseSubspaces(list);
        }
        return list;
    }

    private List<CLIQUESubspace<V>> findDenseSubspaces(Relation<V> relation, List<CLIQUESubspace<V>> list) {
        List<CLIQUESubspace<V>> list2 = this.findDenseSubspaceCandidates(relation, list);
        if (this.prune) {
            return this.pruneDenseSubspaces(list2);
        }
        return list2;
    }

    private Collection<CLIQUEUnit<V>> initOneDimensionalUnits(Relation<V> relation) {
        int n;
        int n2 = RelationUtil.dimensionality(relation);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = -1.7976931348623157E308;
            dArray[i] = Double.MAX_VALUE;
        }
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            this.updateMinMax(numberVector, dArray, dArray2);
            dBIDIter.advance();
        }
        int n3 = 0;
        while (n3 < dArray2.length) {
            int n4 = n3++;
            dArray2[n4] = dArray2[n4] + 1.0E-4;
        }
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = (dArray2[i] - dArray[i]) / (double)this.xsi;
        }
        if (LOG.isDebuggingFiner()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("   minima: ").append(FormatUtil.format(dArray, ", ", FormatUtil.NF2));
            stringBuilder.append("\n   maxima: ").append(FormatUtil.format(dArray2, ", ", FormatUtil.NF2));
            stringBuilder.append("\n   unit lengths: ").append(FormatUtil.format(dArray3, ", ", FormatUtil.NF2));
            LOG.debugFiner(stringBuilder.toString());
        }
        double[][] dArray4 = new double[this.xsi + 1][n2];
        for (int i = 0; i <= this.xsi; ++i) {
            for (n = 0; n < n2; ++n) {
                dArray4[i][n] = i < this.xsi ? dArray[n] + (double)i * dArray3[n] : dArray2[n];
            }
        }
        if (LOG.isDebuggingFiner()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("   unit bounds ").append(FormatUtil.format(new Matrix(dArray4), "   "));
            LOG.debugFiner(stringBuilder.toString());
        }
        ArrayList<CLIQUEUnit<V>> arrayList = new ArrayList<CLIQUEUnit<V>>(this.xsi * n2);
        for (n = 0; n < this.xsi; ++n) {
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new CLIQUEUnit(new CLIQUEInterval(i, dArray4[n][i], dArray4[n + 1][i])));
            }
        }
        if (LOG.isDebuggingFiner()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("   total number of 1-dim units: ").append(arrayList.size());
            LOG.debugFiner(stringBuilder.toString());
        }
        return arrayList;
    }

    private void updateMinMax(V v, double[] dArray, double[] dArray2) {
        if (dArray.length != v.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors differ in length.");
        }
        for (int i = 0; i < v.getDimensionality(); ++i) {
            if (v.doubleValue(i) > dArray2[i]) {
                dArray2[i] = v.doubleValue(i);
            }
            if (!(v.doubleValue(i) < dArray[i])) continue;
            dArray[i] = v.doubleValue(i);
        }
    }

    private List<CLIQUESubspace<V>> findOneDimensionalDenseSubspaceCandidates(Relation<V> relation) {
        ArrayList<CLIQUESubspace<V>> arrayList;
        Object object;
        Collection<CLIQUEUnit<V>> collection = this.initOneDimensionalUnits(relation);
        double d = relation.size();
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = (NumberVector)relation.get((DBIDRef)object2);
            for (CLIQUEUnit<Object> cLIQUEUnit : collection) {
                cLIQUEUnit.addFeatureVector((DBIDRef)object2, object);
            }
            object2.advance();
        }
        object2 = new ArrayList();
        object = new HashMap();
        for (CLIQUEUnit<V> cLIQUEUnit : collection) {
            if (!(cLIQUEUnit.selectivity(d) >= this.tau)) continue;
            object2.add(cLIQUEUnit);
            int n = cLIQUEUnit.getIntervals().iterator().next().getDimension();
            CLIQUESubspace<V> cLIQUESubspace = (CLIQUESubspace<V>)object.get(n);
            if (cLIQUESubspace == null) {
                cLIQUESubspace = new CLIQUESubspace<V>(n);
                object.put(n, cLIQUESubspace);
            }
            cLIQUESubspace.addDenseUnit(cLIQUEUnit);
        }
        if (LOG.isDebugging()) {
            arrayList = new StringBuilder();
            ((StringBuilder)((Object)arrayList)).append("   number of 1-dim dense units: ").append(object2.size());
            ((StringBuilder)((Object)arrayList)).append("\n   number of 1-dim dense subspace candidates: ").append(object.size());
            LOG.debugFine(((StringBuilder)((Object)arrayList)).toString());
        }
        arrayList = new ArrayList<CLIQUESubspace<V>>(object.values());
        Collections.sort(arrayList, new CLIQUESubspace.CoverageComparator());
        return arrayList;
    }

    private List<CLIQUESubspace<V>> findDenseSubspaceCandidates(Relation<V> relation, List<CLIQUESubspace<V>> list) {
        ArrayList<CLIQUESubspace<V>> arrayList = new ArrayList<CLIQUESubspace<V>>(list);
        Collections.sort(arrayList, new Subspace.DimensionComparator());
        double d = relation.size();
        ArrayList<CLIQUESubspace<V>> arrayList2 = new ArrayList<CLIQUESubspace<V>>();
        while (!arrayList.isEmpty()) {
            CLIQUESubspace cLIQUESubspace = (CLIQUESubspace)arrayList.remove(0);
            for (CLIQUESubspace cLIQUESubspace2 : arrayList) {
                CLIQUESubspace cLIQUESubspace3 = cLIQUESubspace.join(cLIQUESubspace2, d, this.tau);
                if (cLIQUESubspace3 == null) continue;
                arrayList2.add(cLIQUESubspace3);
            }
        }
        Collections.sort(arrayList2, new CLIQUESubspace.CoverageComparator());
        return arrayList2;
    }

    private List<CLIQUESubspace<V>> pruneDenseSubspaces(List<CLIQUESubspace<V>> list) {
        int[][] nArray = this.computeMeans(list);
        double[][] dArray = this.computeDiffs(list, nArray[0], nArray[1]);
        double[] dArray2 = new double[list.size()];
        double d = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            int n2 = nArray[0][i];
            int n3 = nArray[1][i];
            double d2 = n2 == 0 ? 0.0 : StrictMath.log(n2) / StrictMath.log(2.0);
            double d3 = n3 == 0 ? 0.0 : StrictMath.log(n3) / StrictMath.log(2.0);
            double d4 = dArray[0][i];
            double d5 = dArray[1][i];
            dArray2[i] = d2 + d4 + d3 + d5;
            if (!(dArray2[i] <= d)) continue;
            d = dArray2[i];
            n = i;
        }
        return list.subList(0, n + 1);
    }

    private int[][] computeMeans(List<CLIQUESubspace<V>> list) {
        int n = list.size() - 1;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            d2 += (double)list.get(n - i).getCoverage();
            nArray[i] = (int)Math.ceil((d += (double)list.get(i).getCoverage()) / (double)(i + 1));
            if (i == n) continue;
            nArray2[n - 1 - i] = (int)Math.ceil(d2 / (double)(i + 1));
        }
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        return nArrayArray;
    }

    private double[][] computeDiffs(List<CLIQUESubspace<V>> list, int[] nArray, int[] nArray2) {
        int n = list.size() - 1;
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3 = i != n ? (double)Math.abs(list.get(n - i).getCoverage() - nArray2[n - 1 - i]) : 0.0;
            d2 += d3 == 0.0 ? 0.0 : StrictMath.log(d3) / StrictMath.log(2.0);
            double d4 = Math.abs(list.get(i).getCoverage() - nArray[i]);
            dArray[i] = d += d4 == 0.0 ? 0.0 : StrictMath.log(d4) / StrictMath.log(2.0);
            if (i == n) continue;
            dArray2[n - 1 - i] = d2;
        }
        double[][] dArrayArray = new double[][]{dArray, dArray2};
        return dArrayArray;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected int xsi;
        protected double tau;
        protected boolean prune;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(XSI_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.xsi = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(TAU_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.tau = doubleParameter.doubleValue();
            }
            if (parameterization.grab(flag = new Flag(PRUNE_ID))) {
                this.prune = flag.isTrue();
            }
        }

        @Override
        protected CLIQUE<V> makeInstance() {
            return new CLIQUE(this.xsi, this.tau, this.prune);
        }
    }
}

