/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DependencyDerivator;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationAnalysisSolution;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Simple COP: Correlation Outlier Probability")
@Reference(authors="Arthur Zimek", title="Correlation Clustering", booktitle="PhD thesis, Chapter 18")
public class SimpleCOP<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleCOP.class);
    int k;
    private DependencyDerivator<V> dependencyDerivator;

    public SimpleCOP(DistanceFunction<? super V> distanceFunction, int n, PCAFilteredRunner pCAFilteredRunner) {
        super(distanceFunction);
        this.k = n;
        this.dependencyDerivator = new DependencyDerivator(null, FormatUtil.NF, pCAFilteredRunner, 0, false);
    }

    public OutlierResult run(Database database, Relation<V> relation) throws IllegalStateException {
        KNNQuery<V> kNNQuery = QueryUtil.getKNNQuery(relation, this.getDistanceFunction(), this.k + 1);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 6);
        WritableDataStore<Vector> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 6, Vector.class);
        WritableDataStore<Matrix> writableDataStore2 = DataStoreUtil.makeStorage(dBIDs, 6, Matrix.class);
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 6, -1);
        WritableDataStore<CorrelationAnalysisSolution> writableDataStore3 = DataStoreUtil.makeStorage(dBIDs, 6, CorrelationAnalysisSolution.class);
        Object object = LOG.isVerbose() ? new FiniteProgress("Correlation Outlier Probabilities", relation.size(), LOG) : null;
        double d = Math.sqrt(2.0);
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k + 1);
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(kNNList);
            arrayModifiableDBIDs.remove(dBIDIter);
            CorrelationAnalysisSolution<NumberVector> correlationAnalysisSolution = this.dependencyDerivator.generateModel(relation, arrayModifiableDBIDs);
            double d2 = correlationAnalysisSolution.getStandardDeviation();
            double d3 = correlationAnalysisSolution.distance((NumberVector)relation.get(dBIDIter));
            double d4 = NormalDistribution.erf(d3 / (d2 * d));
            writableDoubleDataStore.putDouble(dBIDIter, d4);
            Vector vector = correlationAnalysisSolution.errorVector((NumberVector)relation.get(dBIDIter)).timesEquals(-1.0);
            writableDataStore.put(dBIDIter, vector);
            Matrix matrix = correlationAnalysisSolution.dataProjections((NumberVector)relation.get(dBIDIter));
            writableDataStore2.put(dBIDIter, matrix);
            writableIntegerDataStore.putInt(dBIDIter, correlationAnalysisSolution.getCorrelationDimensionality());
            writableDataStore3.put(dBIDIter, correlationAnalysisSolution);
            LOG.incrementProcessed((AbstractProgress)object);
            dBIDIter.advance();
        }
        LOG.ensureCompleted((FiniteProgress)object);
        object = new MaterializedDoubleRelation("Original Correlation Outlier Probabilities", "origcop-outlier", writableDoubleDataStore, dBIDs);
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore();
        OutlierResult outlierResult = new OutlierResult(probabilisticOutlierScore, (DoubleRelation)object);
        outlierResult.addChildResult(new MaterializedRelation<Integer>("Local Dimensionality", "cop-dim", TypeUtil.INTEGER, writableIntegerDataStore, dBIDs));
        outlierResult.addChildResult(new MaterializedRelation<Vector>("Error vectors", "cop-errorvec", TypeUtil.VECTOR, writableDataStore, dBIDs));
        outlierResult.addChildResult(new MaterializedRelation<Matrix>("Data vectors", "cop-datavec", TypeUtil.MATRIX, writableDataStore2, dBIDs));
        outlierResult.addChildResult(new MaterializedRelation<CorrelationAnalysisSolution>("Correlation analysis", "cop-sol", new SimpleTypeInformation<CorrelationAnalysisSolution>(CorrelationAnalysisSolution.class), writableDataStore3, dBIDs));
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("cop.k", "The number of nearest neighbors of an object to be considered for computing its COP_SCORE.");
        public static final OptionID PCARUNNER_ID = new OptionID("cop.pcarunner", "The class to compute (filtered) PCA.");
        int k;
        protected PCAFilteredRunner pca;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(PCARUNNER_ID, (Class<?>)PCAFilteredRunner.class, PCAFilteredRunner.class))) {
                this.pca = (PCAFilteredRunner)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected SimpleCOP<V> makeInstance() {
            return new SimpleCOP(this.distanceFunction, this.k, this.pca);
        }
    }
}

