/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SharedNearestNeighborSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TiedTopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="SOD: Subspace outlier degree")
@Description(value="Outlier Detection in Axis-Parallel Subspaces of High Dimensional Data")
@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Outlier Detection in Axis-Parallel Subspaces of High Dimensional Data", booktitle="Proceedings of the 13th Pacific-Asia Conference on Knowledge Discovery and Data Mining (PAKDD), Bangkok, Thailand, 2009", url="http://dx.doi.org/10.1007/978-3-642-01307-2")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.SOD"})
public class SOD<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SOD.class);
    private int knn;
    private double alpha;
    private SimilarityFunction<V> similarityFunction;
    private boolean models;

    public SOD(int n, double d, SimilarityFunction<V> similarityFunction, boolean bl) {
        this.knn = n;
        this.alpha = d;
        this.similarityFunction = similarityFunction;
        this.models = bl;
    }

    public OutlierResult run(Relation<V> relation) {
        Object object;
        Object object2;
        SimilarityQuery<V> similarityQuery = this.similarityFunction.instantiate(relation);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Assigning Subspace Outlier Degree", relation.size(), LOG) : null;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        WritableDataStore<SODModel> writableDataStore = null;
        if (this.models) {
            writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 4, SODModel.class);
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object3 = relation.iterDBIDs();
        while (object3.valid()) {
            double d;
            long[] lArray;
            LOG.incrementProcessed(finiteProgress);
            object2 = this.getNearestNeighbors(relation, similarityQuery, (DBIDRef)object3);
            if (object2.size() > 0) {
                object = Centroid.make(relation, (DBIDs)object2);
                double[] dArray = SOD.computePerDimensionVariances(relation, (Vector)object, (DBIDs)object2);
                double d2 = Mean.of(dArray);
                lArray = BitsUtil.zero(dArray.length);
                for (int i = 0; i < dArray.length; ++i) {
                    if (!(dArray[i] < this.alpha * d2)) continue;
                    BitsUtil.setI(lArray, i);
                }
                d = this.subspaceOutlierDegree((NumberVector)relation.get((DBIDRef)object3), (Vector)object, lArray);
            } else {
                object = ((NumberVector)relation.get((DBIDRef)object3)).getColumnVector();
                lArray = null;
                d = 0.0;
            }
            if (writableDataStore != null) {
                writableDataStore.put((DBIDRef)object3, new SODModel((Vector)object, lArray));
            }
            writableDoubleDataStore.putDouble((DBIDRef)object3, d);
            doubleMinMax.put(d);
            object3.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object3 = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        object2 = new OutlierResult((OutlierScoreMeta)object3, new MaterializedDoubleRelation("Subspace Outlier Degree", "sod-outlier", writableDoubleDataStore, relation.getDBIDs()));
        if (writableDataStore != null) {
            object = new MaterializedRelation<SODModel>("Subspace Outlier Model", "sod-outlier", new SimpleTypeInformation<SODModel>(SODModel.class), writableDataStore, relation.getDBIDs());
            ((AbstractHierarchicalResult)object2).addChildResult((Result)object);
        }
        return object2;
    }

    private DBIDs getNearestNeighbors(Relation<V> relation, SimilarityQuery<V> similarityQuery, DBIDRef dBIDRef) {
        TiedTopBoundedHeap<DoubleDBIDPair> tiedTopBoundedHeap = new TiedTopBoundedHeap<DoubleDBIDPair>(this.knn);
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            double d;
            if (!DBIDUtil.equal((DBIDRef)object, dBIDRef) && (d = similarityQuery.similarity(dBIDRef, (DBIDRef)object)) > 0.0) {
                ((Heap)tiedTopBoundedHeap).add(DBIDUtil.newPair(d, (DBIDRef)object));
            }
            object.advance();
        }
        object = DBIDUtil.newArray(((Heap)tiedTopBoundedHeap).size());
        while (((Heap)tiedTopBoundedHeap).size() > 0) {
            object.add((DBIDRef)((Heap)tiedTopBoundedHeap).poll());
        }
        return object;
    }

    private static double[] computePerDimensionVariances(Relation<? extends NumberVector> relation, Vector vector, DBIDs dBIDs) {
        double[] dArray = vector.getArrayRef();
        double[] dArray2 = new double[dArray.length];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            int n = 0;
            while (n < dArray.length) {
                double d = numberVector.doubleValue(n) - dArray[n];
                int n2 = n++;
                dArray2[n2] = dArray2[n2] + d * d;
            }
            dBIDIter.advance();
        }
        int n = 0;
        while (n < dArray2.length) {
            int n3 = n++;
            dArray2[n3] = dArray2[n3] / (double)dBIDs.size();
        }
        return dArray2;
    }

    private double subspaceOutlierDegree(V v, Vector vector, long[] lArray) {
        int n = BitsUtil.cardinality(lArray);
        if (n == 0) {
            return 0.0;
        }
        SubspaceEuclideanDistanceFunction subspaceEuclideanDistanceFunction = new SubspaceEuclideanDistanceFunction(lArray);
        double d = subspaceEuclideanDistanceFunction.distance((NumberVector)v, vector);
        return d /= (double)n;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID KNN_ID = new OptionID("sod.knn", "The number of most snn-similar objects to use as reference set for learning the subspace properties.");
        public static final OptionID ALPHA_ID = new OptionID("sod.alpha", "The multiplier for the discriminance value for discerning small from large variances.");
        public static final OptionID SIM_ID = new OptionID("sod.similarity", "The similarity function used for the neighborhood set.");
        public static final OptionID MODELS_ID = new OptionID("sod.models", "Report the models computed by SOD (default: report only scores).");
        private int knn = 1;
        private double alpha = 1.1;
        private SimilarityFunction<V> similarityFunction;
        private boolean models = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(SIM_ID, (Class<?>)SimilarityFunction.class, SharedNearestNeighborSimilarityFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.similarityFunction = (SimilarityFunction)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(KNN_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.knn = (Integer)intParameter.getValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 1.1);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            if (parameterization.grab(flag = new Flag(MODELS_ID))) {
                this.models = flag.isTrue();
            }
        }

        @Override
        protected SOD<V> makeInstance() {
            return new SOD<V>(this.knn, this.alpha, this.similarityFunction, this.models);
        }
    }

    public static class SODModel
    implements TextWriteable {
        private Vector center;
        private long[] weightVector;

        public SODModel(Vector vector, long[] lArray) {
            this.center = vector;
            this.weightVector = lArray;
        }

        @Override
        public void writeToText(TextWriterStream textWriterStream, String string) {
            textWriterStream.commentPrintLn(this.getClass().getSimpleName() + ":");
            textWriterStream.commentPrintLn("relevant attributes (starting with 0): " + BitsUtil.toString(this.weightVector, ", ", 0));
            textWriterStream.commentPrintLn("center of neighborhood: " + textWriterStream.normalizationRestore(this.center).toString());
            textWriterStream.commentPrintSeparator();
        }
    }
}

