/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.spatial;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import java.util.Iterator;
import java.util.List;

public class Polygon
implements SpatialComparable {
    private List<Vector> points;
    private double[] min = null;
    private double[] max = null;

    public Polygon(List<Vector> list) {
        this.points = list;
        if (list.size() > 0) {
            Iterator<Vector> iterator = list.iterator();
            Vector vector = iterator.next();
            int n = vector.getDimensionality();
            this.min = vector.getArrayCopy();
            this.max = vector.getArrayCopy();
            while (iterator.hasNext()) {
                Vector vector2 = iterator.next();
                for (int i = 0; i < n; ++i) {
                    double d = vector2.get(i);
                    this.min[i] = Math.min(this.min[i], d);
                    this.max[i] = Math.max(this.max[i], d);
                }
            }
        }
    }

    public Polygon(List<Vector> list, double d, double d2, double d3, double d4) {
        this.points = list;
        this.min = new double[]{d, d3};
        this.max = new double[]{d2, d4};
    }

    public ArrayListIter<Vector> iter() {
        return new ArrayListIter<Vector>(this.points);
    }

    public void appendToBuffer(StringBuilder stringBuilder) {
        Iterator<Vector> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            double[] dArray = iterator.next().getArrayRef();
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(dArray[i]);
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" ");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendToBuffer(stringBuilder);
        return stringBuilder.toString();
    }

    public int size() {
        return this.points.size();
    }

    public Vector get(int n) {
        return this.points.get(n);
    }

    @Override
    public int getDimensionality() {
        return this.min.length;
    }

    @Override
    public double getMin(int n) {
        return this.min[n];
    }

    @Override
    public double getMax(int n) {
        return this.max[n];
    }

    public int testClockwise() {
        if (this.points.size() < 3) {
            return 0;
        }
        int n = this.points.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            int n3 = (i + 1) % n;
            int n4 = (i + 2) % n;
            double d4 = this.points.get(n3).get(0) - this.points.get(i).get(0);
            double d5 = d4 * (d3 = this.points.get(n4).get(1) - this.points.get(n3).get(1)) - (d2 = this.points.get(n3).get(1) - this.points.get(i).get(1)) * (d = this.points.get(n4).get(0) - this.points.get(n3).get(0));
            if (d5 < 0.0) {
                --n2;
                continue;
            }
            if (!(d5 > 0.0)) continue;
            ++n2;
        }
        if (n2 > 0) {
            return -1;
        }
        if (n2 < 0) {
            return 1;
        }
        return 0;
    }

    public boolean intersects2DIncomplete(Polygon polygon) {
        assert (this.getDimensionality() == 2);
        assert (polygon.getDimensionality() == 2);
        for (Vector vector : this.points) {
            if (!polygon.containsPoint2D(vector)) continue;
            return true;
        }
        for (Vector vector : polygon.points) {
            if (!this.containsPoint2D(vector)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint2D(Vector vector) {
        assert (vector.getDimensionality() == 2);
        double d = vector.get(0);
        double d2 = vector.get(1);
        boolean bl = false;
        Iterator<Vector> iterator = this.points.iterator();
        Vector vector2 = this.points.get(this.points.size() - 1);
        while (iterator.hasNext()) {
            double d3;
            Vector vector3 = iterator.next();
            double d4 = vector3.get(0);
            double d5 = vector3.get(1);
            double d6 = vector2.get(0);
            if (d5 > d2 != (d3 = vector2.get(1)) > d2 && d < (d6 - d4) * (d2 - d5) / (d3 - d5) + d4) {
                bl = !bl;
            }
            vector2 = vector3;
        }
        return bl;
    }
}

