/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import java.util.Collection;

public interface Database
extends HierarchicalResult {
    public void initialize();

    public Collection<Relation<?>> getRelations();

    public <O> Relation<O> getRelation(TypeInformation var1, Object ... var2) throws NoSupportedDataTypeException;

    public <O> DistanceQuery<O> getDistanceQuery(Relation<O> var1, DistanceFunction<? super O> var2, Object ... var3);

    public <O> SimilarityQuery<O> getSimilarityQuery(Relation<O> var1, SimilarityFunction<? super O> var2, Object ... var3);

    public <O> KNNQuery<O> getKNNQuery(DistanceQuery<O> var1, Object ... var2);

    public <O> RangeQuery<O> getRangeQuery(DistanceQuery<O> var1, Object ... var2);

    public <O> RKNNQuery<O> getRKNNQuery(DistanceQuery<O> var1, Object ... var2);

    public SingleObjectBundle getBundle(DBIDRef var1);

    public void addDataStoreListener(DataStoreListener var1);

    public void removeDataStoreListener(DataStoreListener var1);

    public void accumulateDataStoreEvents();

    public void flushDataStoreEvents();
}

