/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import java.util.Arrays;

public class ArrayDoubleStore
implements WritableDoubleDataStore {
    private double[] data;
    private double def;
    private DataStoreIDMap idmap;

    public ArrayDoubleStore(int n, DataStoreIDMap dataStoreIDMap) {
        this(n, dataStoreIDMap, Double.NaN);
    }

    public ArrayDoubleStore(int n, DataStoreIDMap dataStoreIDMap, double d) {
        this.data = new double[n];
        if (d != 0.0) {
            Arrays.fill(this.data, d);
        }
        this.def = d;
        this.idmap = dataStoreIDMap;
    }

    @Override
    @Deprecated
    public Double get(DBIDRef dBIDRef) {
        return this.data[this.idmap.mapDBIDToOffset(dBIDRef)];
    }

    @Override
    @Deprecated
    public Double put(DBIDRef dBIDRef, Double d) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        double d2 = this.data[n];
        this.data[n] = d;
        return d2;
    }

    @Override
    public double doubleValue(DBIDRef dBIDRef) {
        return this.data[this.idmap.mapDBIDToOffset(dBIDRef)];
    }

    @Override
    public double putDouble(DBIDRef dBIDRef, double d) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        double d2 = this.data[n];
        this.data[n] = d;
        return d2;
    }

    @Override
    public double put(DBIDRef dBIDRef, double d) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        double d2 = this.data[n];
        this.data[n] = d;
        return d2;
    }

    @Override
    public void increment(DBIDRef dBIDRef, double d) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        this.data[n] = this.data[n] + d;
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, this.def);
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        throw new UnsupportedOperationException("Can't delete from a static array storage.");
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

