/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerMaxHeap;
import java.util.Arrays;

class DoubleIntegerDBIDKNNHeap
implements KNNHeap {
    private final int k;
    private final DoubleIntegerMaxHeap heap;
    private int[] ties;
    private int numties = 0;
    private double kdist = Double.POSITIVE_INFINITY;
    private static final int INITIAL_TIES_SIZE = 11;

    protected DoubleIntegerDBIDKNNHeap(int n) {
        this.k = n;
        this.heap = new DoubleIntegerMaxHeap(n);
        this.ties = new int[11];
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public double getKNNDistance() {
        return this.kdist;
    }

    @Override
    public final double insert(double d, DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        if (this.heap.size() < this.k) {
            this.heap.add(d, n);
            if (this.heap.size() >= this.k) {
                this.kdist = this.heap.peekKey();
            }
            return this.kdist;
        }
        if (d >= this.kdist) {
            if (d == this.kdist) {
                this.addToTies(n);
            }
            return this.kdist;
        }
        this.updateHeap(d, n);
        return this.kdist;
    }

    @Override
    public void insert(DoubleDBIDPair doubleDBIDPair) {
        double d = doubleDBIDPair.doubleValue();
        int n = doubleDBIDPair.internalGetIndex();
        if (this.heap.size() < this.k) {
            this.heap.add(d, n);
            if (this.heap.size() >= this.k) {
                this.kdist = this.heap.peekKey();
            }
            return;
        }
        if (d >= this.kdist) {
            if (d == this.kdist) {
                this.addToTies(n);
            }
            return;
        }
        this.updateHeap(d, n);
    }

    private final void updateHeap(double d, int n) {
        double d2 = this.kdist;
        int n2 = this.heap.peekValue();
        this.heap.replaceTopElement(d, n);
        this.kdist = this.heap.peekKey();
        if (this.kdist < d2) {
            this.numties = 0;
        } else {
            this.addToTies(n2);
        }
    }

    private final void addToTies(int n) {
        if (this.ties.length == this.numties) {
            this.ties = Arrays.copyOf(this.ties, (this.ties.length << 1) + 1);
        }
        this.ties[this.numties] = n;
        ++this.numties;
    }

    @Override
    public DoubleIntegerDBIDPair poll() {
        if (this.numties > 0) {
            return new DoubleIntegerDBIDPair(this.kdist, this.ties[--this.numties]);
        }
        DoubleIntegerDBIDPair doubleIntegerDBIDPair = new DoubleIntegerDBIDPair(this.heap.peekKey(), this.heap.peekValue());
        this.heap.poll();
        return doubleIntegerDBIDPair;
    }

    protected void pop() {
        if (this.numties > 0) {
            --this.numties;
        } else {
            this.heap.poll();
        }
    }

    @Override
    public DoubleIntegerDBIDPair peek() {
        if (this.numties > 0) {
            return new DoubleIntegerDBIDPair(this.kdist, this.ties[this.numties - 1]);
        }
        return new DoubleIntegerDBIDPair(this.heap.peekKey(), this.heap.peekValue());
    }

    @Override
    public int size() {
        return this.heap.size() + this.numties;
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public void clear() {
        this.heap.clear();
        this.numties = 0;
    }

    @Override
    public DoubleIntegerDBIDKNNList toKNNList() {
        int n;
        int n2 = this.heap.size();
        DoubleIntegerDBIDKNNList doubleIntegerDBIDKNNList = new DoubleIntegerDBIDKNNList(this.k, n2 + this.numties);
        for (n = 0; n < this.numties; ++n) {
            doubleIntegerDBIDKNNList.dists[n2 + n] = this.kdist;
            doubleIntegerDBIDKNNList.ids[n2 + n] = this.ties[n];
        }
        for (n = n2 - 1; n >= 0; --n) {
            doubleIntegerDBIDKNNList.dists[n] = this.heap.peekKey();
            doubleIntegerDBIDKNNList.ids[n] = this.heap.peekValue();
            this.heap.poll();
        }
        doubleIntegerDBIDKNNList.size = n2 + this.numties;
        return doubleIntegerDBIDKNNList;
    }

    protected double peekDistance() {
        return this.numties > 0 ? this.kdist : this.heap.peekKey();
    }

    protected int peekInternalDBID() {
        return this.numties > 0 ? this.ties[this.numties - 1] : this.heap.peekValue();
    }
}

