/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.SplitNumberVectorFilter"})
public class SplitNumberVectorFilter<V extends NumberVector>
implements ObjectFilter {
    final int[] dims;

    public SplitNumberVectorFilter(int[] nArray) {
        this.dims = nArray;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!this.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
                continue;
            }
            VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)VectorFieldTypeInformation.class.cast(simpleTypeInformation);
            NumberVector.Factory factory = FilterUtil.guessFactory(vectorFieldTypeInformation);
            VectorFieldTypeInformation vectorFieldTypeInformation2 = new VectorFieldTypeInformation(factory, this.dims.length);
            VectorFieldTypeInformation vectorFieldTypeInformation3 = new VectorFieldTypeInformation(factory, vectorFieldTypeInformation.getDimensionality() - this.dims.length);
            ArrayList arrayList = new ArrayList(list.size());
            ArrayList arrayList2 = new ArrayList(list.size());
            multipleObjectsBundle2.appendColumn(vectorFieldTypeInformation2, arrayList);
            multipleObjectsBundle2.appendColumn(vectorFieldTypeInformation3, arrayList2);
            int[] nArray = new int[vectorFieldTypeInformation.getDimensionality() - this.dims.length];
            int n = 0;
            for (int j = 0; j < vectorFieldTypeInformation.getDimensionality(); ++j) {
                boolean bl = false;
                for (int k = 0; k < this.dims.length; ++k) {
                    if (this.dims[k] != j) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (n >= nArray.length) {
                    throw new AbortException("Dimensionalities not proper!");
                }
                nArray[n] = j;
                ++n;
            }
            for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
                int n2;
                NumberVector numberVector = (NumberVector)list.get(n);
                double[] dArray = new double[this.dims.length];
                double[] dArray2 = new double[numberVector.getDimensionality() - this.dims.length];
                for (n2 = 0; n2 < this.dims.length; ++n2) {
                    dArray[n2] = numberVector.doubleValue(this.dims[n2]);
                }
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    dArray2[n2] = numberVector.doubleValue(nArray[n2]);
                }
                arrayList.add(factory.newNumberVector(dArray));
                arrayList2.add(factory.newNumberVector(dArray2));
            }
        }
        return multipleObjectsBundle2;
    }

    private TypeInformation getInputTypeRestriction() {
        int n = this.dims[0];
        for (int i = 1; i < this.dims.length; ++i) {
            n = Math.max(this.dims[i], n);
        }
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, n, Integer.MAX_VALUE);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = new OptionID("split.dims", "Dimensions to split into the first relation.");
        protected int[] dims;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = new IntListParameter(SELECTED_ATTRIBUTES_ID);
            intListParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (parameterization.grab(intListParameter)) {
                this.dims = (int[])((int[])intListParameter.getValue()).clone();
            }
        }

        @Override
        protected SplitNumberVectorFilter<V> makeInstance() {
            return new SplitNumberVectorFilter(this.dims);
        }
    }
}

