/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimplePolygonParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimplePolygonParser.class);
    public static final Pattern COORD = Pattern.compile("^([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?),\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?)(?:,\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?))?$");
    public static final String POLYGON_SEPARATOR = "--";
    BundleStreamSource.Event nextevent = null;
    protected BundleMeta meta = null;
    protected boolean haslabels = false;
    protected PolygonsObject curpoly = null;
    protected LabelList curlbl = null;
    protected ExternalID cureid = null;
    private final List<Vector> coords = new ArrayList<Vector>();
    private final List<Polygon> polys = new ArrayList<Polygon>();
    private final ArrayList<String> labels = new ArrayList();

    public SimplePolygonParser(CSVReaderFormat cSVReaderFormat) {
        super(cSVReaderFormat);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event event = this.nextevent;
            this.nextevent = null;
            return event;
        }
        try {
            while (this.reader.nextLineExceptComments()) {
                if (!this.parseLine()) continue;
                if (this.meta == null || this.curlbl != null && !this.haslabels) {
                    this.haslabels = this.haslabels || this.curlbl != null;
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.META_CHANGED;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    protected void buildMeta() {
        if (this.haslabels) {
            this.meta = new BundleMeta(3);
            this.meta.add(TypeUtil.POLYGON_TYPE);
            this.meta.add(TypeUtil.EXTERNALID);
            this.meta.add(TypeUtil.LABELLIST);
        } else {
            this.meta = new BundleMeta(2);
            this.meta.add(TypeUtil.POLYGON_TYPE);
            this.meta.add(TypeUtil.EXTERNALID);
        }
    }

    @Override
    public BundleMeta getMeta() {
        return this.meta;
    }

    @Override
    public Object data(int n) {
        if (n > (this.haslabels ? 2 : 1)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n == 0 ? this.curpoly : (n == 1 ? this.cureid : this.curlbl);
    }

    private boolean parseLine() {
        this.cureid = null;
        this.curpoly = null;
        this.curlbl = null;
        this.polys.clear();
        this.coords.clear();
        this.labels.clear();
        Matcher matcher = COORD.matcher(this.reader.getBuffer());
        while (this.tokenizer.valid()) {
            block12: {
                matcher.region(this.tokenizer.getStart(), this.tokenizer.getEnd());
                if (matcher.find()) {
                    try {
                        double d = FormatUtil.parseDouble(matcher.group(1));
                        double d2 = FormatUtil.parseDouble(matcher.group(2));
                        if (matcher.group(3) != null) {
                            double d3 = FormatUtil.parseDouble(matcher.group(3));
                            this.coords.add(new Vector(d, d2, d3));
                        } else {
                            this.coords.add(new Vector(d, d2));
                        }
                        break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.warning("Looked like a coordinate pair but didn't parse: " + this.tokenizer.getSubstring());
                    }
                }
                int n = this.tokenizer.getEnd() - this.tokenizer.getStart();
                if (POLYGON_SEPARATOR.length() == n && this.reader.getBuffer().subSequence(this.tokenizer.getStart(), this.tokenizer.getEnd()).equals(POLYGON_SEPARATOR)) {
                    if (this.coords.size() > 0) {
                        this.polys.add(new Polygon(new ArrayList<Vector>(this.coords)));
                    }
                } else {
                    String string = this.tokenizer.getSubstring();
                    if (this.cureid == null) {
                        this.cureid = new ExternalID(string);
                    } else {
                        this.labels.add(string);
                    }
                }
            }
            this.tokenizer.advance();
        }
        if (this.coords.size() > 0) {
            this.polys.add(new Polygon(this.coords));
        }
        this.curpoly = new PolygonsObject(this.polys);
        this.curlbl = this.haslabels || this.labels.size() > 0 ? LabelList.make(this.labels) : null;
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected SimplePolygonParser makeInstance() {
            return new SimplePolygonParser(this.format);
        }
    }
}

