/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class EvaluateSimplifiedSilhouette
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSimplifiedSilhouette.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distance;
    private boolean penalize = true;
    private String key = EvaluateSimplifiedSilhouette.class.getName();

    public EvaluateSimplifiedSilhouette(NumberVectorDistanceFunction<?> numberVectorDistanceFunction, NoiseHandling noiseHandling, boolean bl) {
        this.distance = numberVectorDistanceFunction;
        this.noiseOption = noiseHandling;
        this.penalize = bl;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database var1_1, Relation<? extends NumberVector> var2_2, Clustering<?> var3_3) {
        var4_4 = var3_3.getAllClusters();
        var5_5 = new NumberVector[var4_4.size()];
        var6_6 = EvaluateSimplifiedSilhouette.centroids(var2_2, var4_4, var5_5, this.noiseOption);
        var7_7 = new MeanVariance();
        var8_8 = var4_4.iterator();
        var9_9 = 0;
        while (var8_8.hasNext()) {
            block17: {
                block16: {
                    var10_11 = var8_8.next();
                    if (var10_11.size() > 1) break block16;
                    var7_7.put(0.0, var10_11.size());
                    break block17;
                }
                if (!var10_11.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        var7_7.put(0.0, var10_11.size());
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var11_12 = var5_5[var9_9];
                        if (!EvaluateSimplifiedSilhouette.$assertionsDisabled && var11_12 == null) {
                            throw new AssertionError();
                        }
                        var12_14 = var10_11.getIDs().iter();
                        while (var12_14.valid()) {
                            var13_15 = var2_2.get(var12_14);
                            var14_17 = this.distance.distance(var11_12, var13_15);
                            var16_18 = Infinity;
                            var18_20 = var4_4.iterator();
                            var19_21 = 0;
                            while (var18_20.hasNext()) {
                                var20_22 = var18_20.next();
                                if (var9_9 == var19_21) ** GOTO lbl50
                                var21_23 = var5_5[var19_21];
                                if (var21_23 != null) ** GOTO lbl-1000
                                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                                    case 1: {
                                        break;
                                    }
                                    case 2: {
                                        var22_24 = var20_22.getIDs().iter();
                                        while (var22_24.valid()) {
                                            var23_26 = this.distance.distance(var2_2.get(var22_24), var13_15);
                                            var16_18 = var23_26 < var16_18 ? var23_26 : var16_18;
                                            var22_24.advance();
                                        }
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        var16_18 = (var22_25 = this.distance.distance(var21_23, var13_15)) < var16_18 ? var22_25 : var16_18;
                                    }
                                }
lbl50:
                                // 4 sources

                                ++var19_21;
                            }
                            var16_18 = var16_18 < Infinity ? var16_18 : var14_17;
                            var7_7.put((var16_18 - var14_17) / (var16_18 > var14_17 ? var16_18 : var14_17));
                            var12_14.advance();
                        }
                        break block0;
                    }
                }
            }
            ++var9_9;
        }
        var9_10 = 1.0;
        if (this.penalize && var6_6 > 0) {
            var9_10 = (double)(var2_2.size() - var6_6) / (double)var2_2.size();
        }
        var11_13 = var9_10 * var7_7.getMean();
        var13_16 = var9_10 * var7_7.getSampleStddev();
        if (EvaluateSimplifiedSilhouette.LOG.isStatistics()) {
            EvaluateSimplifiedSilhouette.LOG.statistics(new StringStatistic(this.key + ".simplified-silhouette.noise-handling", this.noiseOption.toString()));
            if (var6_6 > 0) {
                EvaluateSimplifiedSilhouette.LOG.statistics(new LongStatistic(this.key + ".simplified-silhouette.ignored", var6_6));
            }
            EvaluateSimplifiedSilhouette.LOG.statistics(new DoubleStatistic(this.key + ".simplified-silhouette.mean", var11_13));
            EvaluateSimplifiedSilhouette.LOG.statistics(new DoubleStatistic(this.key + ".simplified-silhouette.stddev", var13_16));
        }
        var15_27 = EvaluationResult.findOrCreate(var1_1.getHierarchy(), var3_3, "Internal Clustering Evaluation", "internal evaluation");
        var16_19 = var15_27.findOrCreateGroup("Distance-based Evaluation");
        var16_19.addMeasure("Simp. Silhouette +-" + FormatUtil.NF2.format(var13_16), var11_13, -1.0, 1.0, 0.0, false);
        var1_1.getHierarchy().resultChanged(var15_27);
        return var11_13;
    }

    /*
     * Unable to fully structure code
     */
    public static int centroids(Relation<? extends NumberVector> var0, List<? extends Cluster<?>> var1_1, NumberVector[] var2_2, NoiseHandling var3_3) {
        if (!EvaluateSimplifiedSilhouette.$assertionsDisabled && var2_2.length != var1_1.size()) {
            throw new AssertionError();
        }
        var4_4 = 0;
        var5_5 = var1_1.iterator();
        var6_6 = 0;
        while (var5_5.hasNext()) {
            var7_7 = var5_5.next();
            if (var7_7.size() > 1 && !var7_7.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[var3_3.ordinal()]) {
                case 1: {
                    var4_4 += var7_7.size();
                }
                case 2: {
                    var2_2[var6_6] = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var2_2[var6_6] = ModelUtil.getPrototypeOrCentroid(var7_7.getModel(), var0, var7_7.getIDs());
                }
            }
            ++var6_6;
        }
        return var4_4;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling;

        static {
            $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling = new int[NoiseHandling.values().length];
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.IGNORE_NOISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.TREAT_NOISE_AS_SINGLETONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.MERGE_NOISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(EvaluateSilhouette.Parameterizer.DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(EvaluateSilhouette.Parameterizer.NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && parameterization.grab(flag = new Flag(EvaluateSilhouette.Parameterizer.NO_PENALIZE_ID))) {
                this.penalize = flag.isFalse();
            }
        }

        @Override
        protected EvaluateSimplifiedSilhouette makeInstance() {
            return new EvaluateSimplifiedSilhouette(this.distance, this.noiseOption, this.penalize);
        }
    }
}

